/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.domain;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ClassName<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String className = "";
    private Properties initProperties = new Properties();
    private static ObjectMapper mapper = new ObjectMapper();
    public static ClassName EMPTY;

    public ClassName(String className) {
        this(className, "{}");
    }

    public ClassName(String className, String jsonInitProperties) {
        if (StringUtils.isBlank((CharSequence)className)) {
            return;
        }
        if (!ClassName.isClassNameValid(className)) {
            throw new IllegalArgumentException("Invalid className");
        }
        this.className = className;
        try {
            this.initProperties = (Properties)mapper.readValue(jsonInitProperties, Properties.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid JSON: " + jsonInitProperties, e);
        }
    }

    public String getClassName() {
        return this.className;
    }

    public Properties getInitProperties() {
        return this.initProperties;
    }

    public static boolean isClassNameValid(String fqcn) {
        if (StringUtils.isBlank((CharSequence)fqcn)) {
            return false;
        }
        String regex = "([\\p{L}_$][\\p{L}\\p{N}_$]*\\.)*[\\p{L}_$][\\p{L}\\p{N}_$]*";
        return Pattern.matches(regex, fqcn);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.initProperties);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof ClassName)) {
            return false;
        }
        ClassName that = (ClassName)o;
        return this.className.equals(that.getClassName()) && this.getInitProperties().equals(that.getInitProperties());
    }

    static {
        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        EMPTY = new ClassName("");
    }
}

