/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.geode.cache.configuration.CacheElement;
import org.apache.geode.management.api.ClusterManagementResult;
import org.apache.geode.management.api.ClusterManagementService;
import org.apache.geode.management.api.RestfulEndpoint;
import org.apache.geode.management.internal.RestTemplateResponseErrorHandler;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.DefaultUriTemplateHandler;
import org.springframework.web.util.UriTemplateHandler;

public class ClientClusterManagementService
implements ClusterManagementService {
    private static final ResponseErrorHandler DEFAULT_ERROR_HANDLER = new RestTemplateResponseErrorHandler();
    private final RestTemplate restTemplate = new RestTemplate();

    private ClientClusterManagementService() {
        this.restTemplate.setErrorHandler(DEFAULT_ERROR_HANDLER);
    }

    public ClientClusterManagementService(String host, int port, SSLContext sslContext, HostnameVerifier hostnameVerifier, String username, String password) {
        this();
        DefaultUriTemplateHandler templateHandler = new DefaultUriTemplateHandler();
        String schema = sslContext == null ? "http" : "https";
        templateHandler.setBaseUrl(schema + "://" + host + ":" + port + "/geode-management/v2");
        this.restTemplate.setUriTemplateHandler((UriTemplateHandler)templateHandler);
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        if (username != null) {
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(host, port), (Credentials)new UsernamePasswordCredentials(username, password));
            clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
        }
        clientBuilder.setSSLContext(sslContext);
        clientBuilder.setSSLHostnameVerifier(hostnameVerifier);
        requestFactory.setHttpClient((HttpClient)clientBuilder.build());
        this.restTemplate.setRequestFactory((ClientHttpRequestFactory)requestFactory);
    }

    public ClientClusterManagementService(ClientHttpRequestFactory requestFactory) {
        this();
        this.restTemplate.setRequestFactory(requestFactory);
    }

    @Override
    public ClusterManagementResult create(CacheElement config, String group) {
        String endPoint = this.getEndpoint(config);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        return (ClusterManagementResult)this.restTemplate.postForObject(endPoint, (Object)config, ClusterManagementResult.class, new Object[0]);
    }

    @Override
    public ClusterManagementResult delete(CacheElement config, String group) {
        throw new NotImplementedException("Not Implemented");
    }

    @Override
    public ClusterManagementResult update(CacheElement config, String group) {
        throw new NotImplementedException("Not Implemented");
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    private String getEndpoint(CacheElement config) {
        if (!(config instanceof RestfulEndpoint)) {
            throw new IllegalArgumentException(String.format("The config type %s does not have a RESTful endpoint defined", config.getClass().getName()));
        }
        return ((RestfulEndpoint)((Object)config)).getEndpoint();
    }
}

