/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.util.Date;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.management.api.ClusterManagementResult;
import org.apache.geode.management.api.RestTemplateClusterManagementServiceTransport;
import org.apache.geode.management.internal.ClusterManagementOperationStatusResult;
import org.apache.geode.management.internal.Dormant;
import org.apache.geode.management.runtime.OperationResult;
import org.springframework.http.HttpMethod;
import org.springframework.web.client.RestTemplate;

@Experimental
public class CompletableFutureProxy<V extends OperationResult>
extends CompletableFuture<V>
implements Dormant {
    private static final int POLL_INTERVAL = 1000;
    private static final int TOLERABLE_FAILURES = 3;
    private int consecutiveCheckFailures = 0;
    private final ScheduledExecutorService pool;
    private final RestTemplate restTemplate;
    private final String uri;
    private ScheduledFuture<?> scheduledFuture;
    private final CompletableFuture<Date> futureOperationEnded;

    public CompletableFutureProxy(RestTemplate restTemplate, String uri, ScheduledExecutorService pool, CompletableFuture<Date> futureOperationEnded) {
        this.restTemplate = restTemplate;
        this.uri = uri;
        this.pool = pool;
        this.futureOperationEnded = futureOperationEnded;
    }

    @Override
    public void wakeUp() {
        this.startPolling();
    }

    private synchronized void startPolling() {
        if (this.scheduledFuture != null) {
            return;
        }
        this.scheduledFuture = this.pool.scheduleWithFixedDelay(() -> {
            ClusterManagementOperationStatusResult<V> result;
            if (this.isDone()) {
                this.futureOperationEnded.complete(null);
                this.scheduledFuture.cancel(true);
                return;
            }
            try {
                result = this.requestStatus();
                this.consecutiveCheckFailures = 0;
            }
            catch (Exception e) {
                if (++this.consecutiveCheckFailures > 3) {
                    this.futureOperationEnded.complete(null);
                    this.completeExceptionally(new RuntimeException("Lost connectivity to locator " + e));
                }
                return;
            }
            this.completeAccordingToStatus(result);
        }, 0L, 1000L, TimeUnit.MILLISECONDS);
    }

    private void completeAccordingToStatus(ClusterManagementOperationStatusResult<V> result) {
        ClusterManagementResult.StatusCode statusCode = result.getStatusCode();
        if (statusCode == ClusterManagementResult.StatusCode.OK) {
            this.futureOperationEnded.complete(result.getOperationEnded());
            this.complete(result.getResult());
        } else if (statusCode != ClusterManagementResult.StatusCode.IN_PROGRESS) {
            this.futureOperationEnded.complete(null);
            this.completeExceptionally(new RuntimeException((Object)((Object)statusCode) + ": " + result.getStatusMessage()));
        }
    }

    private ClusterManagementOperationStatusResult<V> requestStatus() {
        return (ClusterManagementOperationStatusResult)this.restTemplate.exchange(this.uri, HttpMethod.GET, RestTemplateClusterManagementServiceTransport.makeEntity(null), ClusterManagementOperationStatusResult.class, new Object[0]).getBody();
    }
}

