/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.configuration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.lang.Identifiable;
import org.apache.geode.management.api.JsonSerializable;
import org.apache.geode.management.configuration.Links;
import org.apache.geode.management.runtime.RuntimeInfo;

@Experimental
public abstract class AbstractConfiguration<R extends RuntimeInfo>
implements Identifiable<String>,
JsonSerializable {
    public static final String CLUSTER = "cluster";

    public static boolean isCluster(String groupName) {
        return StringUtils.isBlank((CharSequence)groupName) || groupName.equalsIgnoreCase(CLUSTER);
    }

    public static String getGroupName(String group) {
        return AbstractConfiguration.isCluster(group) ? CLUSTER : group;
    }

    @JsonIgnore
    public String getGroup() {
        return null;
    }

    public abstract String getId();

    @JsonIgnore
    public abstract Links getLinks();

    @JsonIgnore
    public boolean isGlobalRuntime() {
        return false;
    }
}

