/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.api;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.management.api.ClusterManagementResult;
import org.apache.geode.management.internal.Dormant;
import org.apache.geode.management.runtime.OperationResult;

@Experimental
public class ClusterManagementOperationResult<V extends OperationResult>
extends ClusterManagementResult {
    @JsonIgnore
    private final CompletableFuture<V> operationResult;
    @JsonIgnore
    private final CompletableFuture<Date> futureOperationEnded;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    private Date operationStart;
    private String operationId;
    private String operator;

    public ClusterManagementOperationResult() {
        this.operationResult = null;
        this.futureOperationEnded = null;
        this.operator = null;
    }

    public ClusterManagementOperationResult(ClusterManagementResult result, CompletableFuture<V> operationResult, Date operationStart, CompletableFuture<Date> futureOperationEnded, String operator, String operationId) {
        super(result);
        this.operationResult = operationResult;
        this.operationStart = operationStart;
        this.futureOperationEnded = futureOperationEnded;
        this.operator = operator;
        this.operationId = operationId;
    }

    @JsonIgnore
    public CompletableFuture<V> getFutureResult() {
        if (this.operationResult instanceof Dormant) {
            ((Dormant)((Object)this.operationResult)).wakeUp();
        }
        return this.operationResult;
    }

    @JsonIgnore
    public V getResult() throws ExecutionException, InterruptedException {
        return (V)((OperationResult)this.getFutureResult().get());
    }

    public Date getOperationStart() {
        return this.operationStart;
    }

    @JsonIgnore
    public CompletableFuture<Date> getFutureOperationEnded() {
        return this.futureOperationEnded;
    }

    @JsonProperty
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    public Date getOperationEnded() {
        return this.futureOperationEnded.getNow(null);
    }

    public String getOperator() {
        return this.operator;
    }

    public String getOperationId() {
        return this.operationId;
    }
}

