/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.geode.management.api.ClusterManagementService;
import org.apache.geode.management.client.ClusterManagementServiceBuilder;
import org.apache.geode.management.internal.ClientClusterManagementService;
import org.apache.geode.management.internal.RestTemplateResponseErrorHandler;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.DefaultUriTemplateHandler;
import org.springframework.web.util.UriTemplateHandler;

public class PlainClusterManagementServiceBuilder
implements ClusterManagementServiceBuilder.PlainBuilder {
    protected String host;
    protected int port;
    protected SSLContext sslContext;
    protected HostnameVerifier hostnameVerifier;
    protected String username;
    protected String password;
    static final ResponseErrorHandler DEFAULT_ERROR_HANDLER = new RestTemplateResponseErrorHandler();

    @Override
    public PlainClusterManagementServiceBuilder setHostAddress(String host, int port) {
        this.host = host;
        this.port = port;
        return this;
    }

    @Override
    public PlainClusterManagementServiceBuilder setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    @Override
    public PlainClusterManagementServiceBuilder setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    @Override
    public PlainClusterManagementServiceBuilder setCredentials(String username, String password) {
        this.username = username;
        this.password = password;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    @Override
    public ClusterManagementService build() {
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setErrorHandler(DEFAULT_ERROR_HANDLER);
        if (this.host == null || this.port <= 0) {
            throw new IllegalArgumentException("host and port needs to be specified in order to build the service.");
        }
        DefaultUriTemplateHandler templateHandler = new DefaultUriTemplateHandler();
        String schema = this.sslContext == null ? "http" : "https";
        templateHandler.setBaseUrl(schema + "://" + this.host + ":" + this.port + "/management");
        restTemplate.setUriTemplateHandler((UriTemplateHandler)templateHandler);
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        if (this.username != null) {
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(this.host, this.port), (Credentials)new UsernamePasswordCredentials(this.username, this.password));
            clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
        }
        clientBuilder.setSSLContext(this.sslContext);
        clientBuilder.setSSLHostnameVerifier(this.hostnameVerifier);
        requestFactory.setHttpClient((HttpClient)clientBuilder.build());
        restTemplate.setRequestFactory((ClientHttpRequestFactory)requestFactory);
        return new ClientClusterManagementService(restTemplate);
    }
}

