/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.configuration.CacheElement;
import org.apache.geode.management.api.ClusterManagementResult;
import org.apache.geode.management.api.ConfigurationResult;
import org.apache.geode.management.runtime.RuntimeInfo;

@Experimental
public class ClusterManagementListResult<T extends CacheElement, R extends RuntimeInfo>
extends ClusterManagementResult {
    @JsonInclude
    @JsonProperty
    private List<ConfigurationResult<T, R>> result = new ArrayList<ConfigurationResult<T, R>>();

    public ClusterManagementListResult() {
    }

    public ClusterManagementListResult(ClusterManagementResult.StatusCode statusCode, String message) {
        super(statusCode, message);
    }

    public List<ConfigurationResult<T, R>> getResult() {
        return this.result;
    }

    @JsonIgnore
    public List<T> getConfigResult() {
        return this.result.stream().map(ConfigurationResult::getConfig).collect(Collectors.toList());
    }

    @JsonIgnore
    public List<R> getRuntimeResult() {
        return this.result.stream().flatMap(r -> r.getRuntimeInfo().stream()).collect(Collectors.toList());
    }

    public void setResult(List<ConfigurationResult<T, R>> result) {
        this.result = result;
    }
}

