/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.configuration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.lang.Identifiable;
import org.apache.geode.management.api.JsonSerializable;

@Experimental
public abstract class CacheElement
implements Identifiable<String>,
Serializable,
JsonSerializable {
    public static final String CLUSTER = "cluster";
    protected List<String> groups = new ArrayList<String>();

    public static <T extends Identifiable> boolean exists(List<T> list, String id) {
        return list.stream().anyMatch(o -> o.getId().equals(id));
    }

    public static <T extends Identifiable> T findElement(List<T> list, String id) {
        return (T)((Identifiable)list.stream().filter(o -> o.getId().equals(id)).findFirst().orElse(null));
    }

    public static <T extends Identifiable> void removeElement(List<T> list, String id) {
        list.removeIf(t -> t.getId().equals(id));
    }

    @XmlTransient
    @JsonIgnore
    public String getConfigGroup() {
        String group = this.getGroup();
        if (StringUtils.isBlank((CharSequence)group)) {
            return CLUSTER;
        }
        return group;
    }

    @XmlTransient
    @JsonIgnore
    public String getGroup() {
        if (this.groups.size() == 0) {
            return null;
        }
        return this.groups.get(0);
    }

    @JsonSetter
    public void setGroup(String group) {
        this.groups.clear();
        if (StringUtils.isBlank((CharSequence)group)) {
            return;
        }
        this.groups.add(group);
    }

    @XmlTransient
    public List<String> getGroups() {
        return this.groups;
    }

    public void addGroup(String group) {
        this.groups.add(group);
    }
}

