/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.cli.commands;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.cache.lucene.internal.cli.LuceneIndexDetails;
import org.apache.geode.cache.lucene.internal.cli.commands.LuceneCommandBase;
import org.apache.geode.cache.lucene.internal.cli.functions.LuceneListIndexFunction;
import org.apache.geode.internal.cache.execute.AbstractExecution;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellMethodAvailability;
import org.springframework.shell.standard.ShellOption;

public class LuceneListIndexCommand
extends LuceneCommandBase {
    @ShellMethod(value="Display the list of lucene indexes created for all members.", key={"list lucene indexes"})
    @CliMetaData(relatedTopic={"Region", "Data"})
    public ResultModel listIndex(@ShellOption(value={"with-stats"}, defaultValue="false", arity=0, help="Display lucene index stats") boolean stats) {
        this.authorize(ResourcePermission.Resource.CLUSTER, ResourcePermission.Operation.READ, "LUCENE");
        return this.toTabularResult(this.getIndexListing(), stats);
    }

    protected List<LuceneIndexDetails> getIndexListing() {
        Execution functionExecutor = this.getMembersFunctionExecutor(this.getAllMembers());
        if (functionExecutor instanceof AbstractExecution) {
            ((AbstractExecution)functionExecutor).setIgnoreDepartedMembers(true);
        }
        ResultCollector resultsCollector = functionExecutor.execute((Function)new LuceneListIndexFunction());
        List results = (List)resultsCollector.getResult();
        List<LuceneIndexDetails> sortedResults = results.stream().flatMap(Collection::stream).sorted().collect(Collectors.toList());
        LinkedHashSet uniqResults = new LinkedHashSet(sortedResults);
        sortedResults.clear();
        sortedResults.addAll(uniqResults);
        return sortedResults;
    }

    @Override
    @ShellMethodAvailability(value={"list lucene indexes"})
    public boolean indexCommandsAvailable() {
        return super.indexCommandsAvailable();
    }
}

