/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.cli;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.geode.cache.lucene.LuceneSerializer;
import org.apache.geode.cache.lucene.internal.LuceneIndexCreationProfile;
import org.apache.geode.cache.lucene.internal.LuceneIndexImpl;
import org.apache.geode.cache.lucene.internal.LuceneIndexStats;
import org.apache.geode.cache.lucene.internal.cli.LuceneFunctionSerializable;
import org.apache.geode.cache.lucene.internal.cli.LuceneIndexStatus;
import org.apache.geode.cache.lucene.internal.repository.serializer.HeterogeneousLuceneSerializer;
import org.apache.lucene.analysis.Analyzer;

public class LuceneIndexDetails
extends LuceneFunctionSerializable
implements Comparable<LuceneIndexDetails> {
    private static final long serialVersionUID = 1L;
    private final String serverName;
    private final String[] searchableFieldNames;
    private Map<String, String> fieldAnalyzers = null;
    private final Map<String, Integer> indexStats;
    private final LuceneIndexStatus status;
    private String serializer;

    public LuceneIndexDetails(String indexName, String regionPath, String[] searchableFieldNames, Map<String, Analyzer> fieldAnalyzers, LuceneIndexStats indexStats, LuceneIndexStatus status, String serverName, LuceneSerializer serializer) {
        super(indexName, regionPath);
        this.serverName = serverName;
        this.searchableFieldNames = searchableFieldNames;
        this.fieldAnalyzers = this.getFieldAnalyzerStrings(fieldAnalyzers);
        this.indexStats = this.getIndexStatsMap(indexStats);
        this.status = status;
        this.serializer = serializer != null ? serializer.getClass().getSimpleName() : HeterogeneousLuceneSerializer.class.getSimpleName();
    }

    public LuceneIndexDetails(LuceneIndexImpl index, String serverName) {
        this(index.getName(), index.getRegionPath(), index.getFieldNames(), index.getFieldAnalyzers(), index.getIndexStats(), LuceneIndexStatus.INITIALIZED, serverName, index.getLuceneSerializer());
    }

    public LuceneIndexDetails(LuceneIndexImpl index, String serverName, LuceneIndexStatus status) {
        this(index.getName(), index.getRegionPath(), index.getFieldNames(), index.getFieldAnalyzers(), index.getIndexStats(), status, serverName, index.getLuceneSerializer());
    }

    public LuceneIndexDetails(LuceneIndexCreationProfile indexProfile, String serverName) {
        this(indexProfile.getIndexName(), indexProfile.getRegionPath(), indexProfile.getFieldNames(), null, null, LuceneIndexStatus.NOT_INITIALIZED, serverName, null);
        this.fieldAnalyzers = this.getFieldAnalyzerStringsFromProfile(indexProfile.getFieldAnalyzers());
        this.serializer = indexProfile.getSerializerClass();
    }

    public LuceneIndexDetails(LuceneIndexCreationProfile indexProfile, String serverName, LuceneIndexStatus status) {
        this(indexProfile.getIndexName(), indexProfile.getRegionPath(), indexProfile.getFieldNames(), null, null, status, serverName, null);
        this.fieldAnalyzers = this.getFieldAnalyzerStringsFromProfile(indexProfile.getFieldAnalyzers());
        this.serializer = indexProfile.getSerializerClass();
    }

    public Map<String, Integer> getIndexStats() {
        return this.indexStats;
    }

    private Map<String, Integer> getIndexStatsMap(LuceneIndexStats indexStats) {
        HashMap<String, Integer> statsMap = new HashMap<String, Integer>();
        if (indexStats == null) {
            return statsMap;
        }
        statsMap.put("queryExecutions", indexStats.getQueryExecutions());
        statsMap.put("updates", indexStats.getUpdates());
        statsMap.put("commits", indexStats.getCommits());
        statsMap.put("documents", indexStats.getDocuments());
        return statsMap;
    }

    public String getIndexStatsString() {
        return this.indexStats.toString();
    }

    private Map<String, String> getFieldAnalyzerStrings(Map<String, Analyzer> fieldAnalyzers) {
        if (fieldAnalyzers == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> results = new HashMap<String, String>();
        for (Map.Entry<String, Analyzer> entry : fieldAnalyzers.entrySet()) {
            Analyzer analyzer = entry.getValue();
            if (analyzer == null) continue;
            results.put(entry.getKey(), analyzer.getClass().getSimpleName());
        }
        return results;
    }

    private Map<String, String> getFieldAnalyzerStringsFromProfile(Map<String, String> fieldAnalyzers) {
        if (fieldAnalyzers == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> results = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : fieldAnalyzers.entrySet()) {
            String analyzer = entry.getValue();
            if (analyzer == null) continue;
            results.put(entry.getKey(), analyzer);
        }
        return results;
    }

    public String getSearchableFieldNamesString() {
        return Arrays.asList(this.searchableFieldNames).toString();
    }

    public String getFieldAnalyzersString() {
        return this.fieldAnalyzers.toString();
    }

    public String getSerializerString() {
        return this.serializer;
    }

    public String toString() {
        return "{\n\tIndex Name = " + this.indexName + ",\tRegion Path = " + this.regionPath + ",\tIndexed Fields = " + this.getSearchableFieldNamesString() + ",\tField Analyzer = " + this.getFieldAnalyzersString() + ",\tSerializer = " + this.getSerializerString() + ",\tStatus =\n\t" + String.valueOf((Object)this.getStatus()) + ",\tIndex Statistics =\n\t" + this.getIndexStatsString() + "\n}\n";
    }

    public LuceneIndexStatus getStatus() {
        return this.status;
    }

    private static <T extends Comparable<T>> int compare(T obj1, T obj2) {
        return obj1 == null && obj2 == null ? 0 : (obj1 == null ? 1 : (obj2 == null ? -1 : obj1.compareTo(obj2)));
    }

    @Override
    public int compareTo(LuceneIndexDetails indexDetails) {
        int comparisonValue = LuceneIndexDetails.compare(this.getIndexName(), indexDetails.getIndexName());
        return comparisonValue != 0 ? comparisonValue : LuceneIndexDetails.compare(this.getRegionPath(), indexDetails.getRegionPath());
    }

    public String getServerName() {
        return this.serverName;
    }
}

