/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.cli.functions;

import org.apache.commons.lang.StringUtils;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.lucene.LuceneService;
import org.apache.geode.cache.lucene.LuceneServiceProvider;
import org.apache.geode.cache.lucene.internal.LuceneServiceImpl;
import org.apache.geode.cache.lucene.internal.cli.LuceneDestroyIndexInfo;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;

public class LuceneDestroyIndexFunction
implements InternalFunction {
    public void execute(FunctionContext context) {
        CliFunctionResult result;
        block11: {
            String memberId = context.getCache().getDistributedSystem().getDistributedMember().getId();
            try {
                LuceneDestroyIndexInfo indexInfo = (LuceneDestroyIndexInfo)context.getArguments();
                String indexName = indexInfo.getIndexName();
                String regionPath = indexInfo.getRegionPath();
                LuceneService service = LuceneServiceProvider.get((GemFireCache)context.getCache());
                if (indexName == null) {
                    if (indexInfo.isDefinedDestroyOnly()) {
                        ((LuceneServiceImpl)service).destroyDefinedIndexes(regionPath);
                        result = new CliFunctionResult(memberId);
                        break block11;
                    }
                    CliFunctionResult destroyIndexesResult = null;
                    Exception destroyIndexesException = null;
                    try {
                        service.destroyIndexes(regionPath);
                        destroyIndexesResult = new CliFunctionResult(memberId, this.getXmlEntity(indexName, regionPath));
                    }
                    catch (Exception e) {
                        destroyIndexesException = e;
                    }
                    CliFunctionResult destroyDefinedIndexesResult = null;
                    Exception destroyDefinedIndexesException = null;
                    try {
                        ((LuceneServiceImpl)service).destroyDefinedIndexes(regionPath);
                        destroyDefinedIndexesResult = new CliFunctionResult(memberId);
                    }
                    catch (Exception e) {
                        destroyDefinedIndexesException = e;
                    }
                    if (destroyIndexesException != null && destroyDefinedIndexesException != null) {
                        throw destroyIndexesException;
                    }
                    result = destroyIndexesResult == null ? destroyDefinedIndexesResult : destroyIndexesResult;
                    break block11;
                }
                if (indexInfo.isDefinedDestroyOnly()) {
                    ((LuceneServiceImpl)service).destroyDefinedIndex(indexName, regionPath);
                    result = new CliFunctionResult(memberId);
                } else {
                    service.destroyIndex(indexName, regionPath);
                    result = new CliFunctionResult(memberId, this.getXmlEntity(indexName, regionPath));
                }
            }
            catch (Exception e) {
                result = new CliFunctionResult(memberId, (Object)e, e.getMessage());
            }
        }
        context.getResultSender().lastResult((Object)result);
    }

    protected XmlEntity getXmlEntity(String indexName, String regionPath) {
        String regionName = StringUtils.stripStart((String)regionPath, (String)"/");
        return new XmlEntity("region", "name", regionName, "lucene", "http://geode.apache.org/schema/lucene", "index", "name", indexName);
    }
}

