/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.management;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geode.cache.lucene.LuceneIndex;
import org.apache.geode.cache.lucene.LuceneService;
import org.apache.geode.cache.lucene.internal.LuceneIndexImpl;
import org.apache.geode.cache.lucene.internal.management.LuceneIndexStatsMonitor;
import org.apache.geode.cache.lucene.management.LuceneIndexMetrics;

public class LuceneServiceBridge {
    private LuceneService service;
    private Map<String, LuceneIndexStatsMonitor> monitors;

    public LuceneServiceBridge(LuceneService service) {
        this.service = service;
        this.monitors = new ConcurrentHashMap<String, LuceneIndexStatsMonitor>();
    }

    public void addIndex(LuceneIndex index) {
        LuceneIndexStatsMonitor monitor = new LuceneIndexStatsMonitor(index);
        this.monitors.put(this.getMonitorKey(index), monitor);
    }

    public LuceneIndexMetrics[] listIndexMetrics() {
        Collection<LuceneIndex> indexes = this.service.getAllIndexes();
        LuceneIndexMetrics[] indexMetrics = new LuceneIndexMetrics[indexes.size()];
        int i = 0;
        for (LuceneIndex index : this.service.getAllIndexes()) {
            indexMetrics[i++] = this.getIndexMetrics((LuceneIndexImpl)index);
        }
        return indexMetrics;
    }

    public LuceneIndexMetrics[] listIndexMetrics(String regionPath) {
        if (!regionPath.startsWith("/")) {
            regionPath = "/" + regionPath;
        }
        ArrayList<LuceneIndexMetrics> indexMetrics = new ArrayList<LuceneIndexMetrics>();
        for (LuceneIndex index : this.service.getAllIndexes()) {
            if (!index.getRegionPath().equals(regionPath)) continue;
            indexMetrics.add(this.getIndexMetrics((LuceneIndexImpl)index));
        }
        return indexMetrics.toArray(new LuceneIndexMetrics[indexMetrics.size()]);
    }

    public LuceneIndexMetrics listIndexMetrics(String regionPath, String indexName) {
        LuceneIndexImpl index = (LuceneIndexImpl)this.service.getIndex(indexName, regionPath);
        return index == null ? null : this.getIndexMetrics(index);
    }

    private String getMonitorKey(LuceneIndex index) {
        return index.getRegionPath() + "_" + index.getName();
    }

    private LuceneIndexMetrics getIndexMetrics(LuceneIndexImpl index) {
        LuceneIndexStatsMonitor monitor = this.monitors.get(this.getMonitorKey(index));
        return monitor.getIndexMetrics(index);
    }
}

