/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.cli.functions;

import java.util.HashSet;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.lucene.LuceneQuery;
import org.apache.geode.cache.lucene.LuceneQueryException;
import org.apache.geode.cache.lucene.LuceneService;
import org.apache.geode.cache.lucene.LuceneServiceProvider;
import org.apache.geode.cache.lucene.PageableLuceneQueryResults;
import org.apache.geode.cache.lucene.internal.cli.LuceneQueryInfo;
import org.apache.geode.cache.lucene.internal.cli.LuceneSearchResults;
import org.apache.geode.internal.InternalEntity;

public class LuceneSearchIndexFunction<K, V>
implements InternalEntity,
Function {
    private static final long serialVersionUID = 163818919780803222L;

    public String getId() {
        return LuceneSearchIndexFunction.class.getName();
    }

    public void execute(FunctionContext context) {
        HashSet result = new HashSet();
        Cache cache = context.getCache();
        LuceneQueryInfo queryInfo = (LuceneQueryInfo)context.getArguments();
        LuceneService luceneService = LuceneServiceProvider.get((GemFireCache)context.getCache());
        try {
            if (luceneService.getIndex(queryInfo.getIndexName(), queryInfo.getRegionPath()) == null) {
                throw new Exception("Index " + queryInfo.getIndexName() + " not found on region " + queryInfo.getRegionPath());
            }
            LuceneQuery query = luceneService.createLuceneQueryFactory().setLimit(queryInfo.getLimit()).create(queryInfo.getIndexName(), queryInfo.getRegionPath(), queryInfo.getQueryString(), queryInfo.getDefaultField());
            if (queryInfo.getKeysOnly()) {
                query.findKeys().forEach(key -> result.add(new LuceneSearchResults(key.toString())));
            } else {
                PageableLuceneQueryResults pageableLuceneQueryResults = query.findPages();
                while (pageableLuceneQueryResults.hasNext()) {
                    Object page = pageableLuceneQueryResults.next();
                    page.stream().forEach(searchResult -> result.add(new LuceneSearchResults(searchResult.getKey().toString(), searchResult.getValue().toString(), searchResult.getScore())));
                }
            }
            if (result != null) {
                context.getResultSender().lastResult(result);
            }
        }
        catch (LuceneQueryException e) {
            result.add(new LuceneSearchResults(true, e.getRootCause().getMessage()));
            context.getResultSender().lastResult(result);
        }
        catch (Exception e) {
            result.add(new LuceneSearchResults(true, e.getMessage()));
            context.getResultSender().lastResult(result);
        }
    }
}

