/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.cli.functions;

import org.apache.commons.lang.StringUtils;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.lucene.LuceneSerializer;
import org.apache.geode.cache.lucene.LuceneService;
import org.apache.geode.cache.lucene.LuceneServiceProvider;
import org.apache.geode.cache.lucene.internal.LuceneIndexFactoryImpl;
import org.apache.geode.cache.lucene.internal.LuceneServiceImpl;
import org.apache.geode.cache.lucene.internal.cli.LuceneIndexInfo;
import org.apache.geode.internal.InternalEntity;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;

public class LuceneCreateIndexFunction
implements InternalEntity,
Function {
    private static final long serialVersionUID = 3061443846664615818L;

    public String getId() {
        return LuceneCreateIndexFunction.class.getName();
    }

    public void execute(FunctionContext context) {
        String memberId = null;
        try {
            LuceneIndexInfo indexInfo = (LuceneIndexInfo)context.getArguments();
            Cache cache = context.getCache();
            memberId = cache.getDistributedSystem().getDistributedMember().getId();
            LuceneService service = LuceneServiceProvider.get((GemFireCache)cache);
            LuceneServiceImpl.validateCommandParameters.INDEX_NAME.validateName(indexInfo.getIndexName());
            String[] fields = indexInfo.getSearchableFieldNames();
            String[] analyzerName = indexInfo.getFieldAnalyzers();
            String serializerName = indexInfo.getSerializer();
            LuceneIndexFactoryImpl indexFactory = (LuceneIndexFactoryImpl)service.createIndexFactory();
            if (analyzerName == null || analyzerName.length == 0) {
                for (String field : fields) {
                    indexFactory.addField(field);
                }
            } else {
                if (analyzerName.length != fields.length) {
                    throw new Exception("Mismatch in lengths of fields and analyzers");
                }
                for (int i = 0; i < fields.length; ++i) {
                    Analyzer analyzer = this.toAnalyzer(analyzerName[i]);
                    indexFactory.addField(fields[i], analyzer);
                }
            }
            if (serializerName != null && !serializerName.equals("")) {
                indexFactory.setLuceneSerializer(this.toSerializer(serializerName));
            }
            LuceneServiceImpl.validateCommandParameters.REGION_PATH.validateName(indexInfo.getRegionPath());
            if (LuceneServiceImpl.LUCENE_REINDEX) {
                indexFactory.create(indexInfo.getIndexName(), indexInfo.getRegionPath(), true);
            } else {
                indexFactory.create(indexInfo.getIndexName(), indexInfo.getRegionPath(), false);
            }
            XmlEntity xmlEntity = null;
            context.getResultSender().lastResult((Object)new CliFunctionResult(memberId, xmlEntity));
        }
        catch (Exception e) {
            String exceptionMessage = CliStrings.format((String)"Exception : {0} , Message : {1}", (Object[])new Object[]{e.getClass().getName(), e.getMessage()});
            context.getResultSender().lastResult((Object)new CliFunctionResult(memberId, (Throwable)e, e.getMessage()));
        }
    }

    private LuceneSerializer toSerializer(String serializerName) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String trimmedName = StringUtils.trim((String)serializerName);
        if (trimmedName == "") {
            return null;
        }
        Class clazz = CliUtil.forName((String)serializerName, (String)"serializer");
        return (LuceneSerializer)CliUtil.newInstance((Class)clazz, (String)"serializer");
    }

    private Analyzer toAnalyzer(String className) {
        String trimmedClassName;
        className = className == null ? StandardAnalyzer.class.getCanonicalName() : ((trimmedClassName = StringUtils.trim((String)className)).equals("") || trimmedClassName.equals("DEFAULT") ? StandardAnalyzer.class.getCanonicalName() : trimmedClassName);
        Class clazz = CliUtil.forName((String)className, (String)"analyzer");
        return (Analyzer)CliUtil.newInstance((Class)clazz, (String)"analyzer");
    }
}

