/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionInvocationTargetException;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.cache.lucene.internal.cli.LuceneDestroyIndexInfo;
import org.apache.geode.cache.lucene.internal.cli.LuceneFunctionSerializable;
import org.apache.geode.cache.lucene.internal.cli.LuceneIndexDetails;
import org.apache.geode.cache.lucene.internal.cli.LuceneIndexInfo;
import org.apache.geode.cache.lucene.internal.cli.LuceneQueryInfo;
import org.apache.geode.cache.lucene.internal.cli.LuceneSearchResults;
import org.apache.geode.cache.lucene.internal.cli.functions.LuceneCreateIndexFunction;
import org.apache.geode.cache.lucene.internal.cli.functions.LuceneDescribeIndexFunction;
import org.apache.geode.cache.lucene.internal.cli.functions.LuceneDestroyIndexFunction;
import org.apache.geode.cache.lucene.internal.cli.functions.LuceneListIndexFunction;
import org.apache.geode.cache.lucene.internal.cli.functions.LuceneSearchIndexFunction;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.execute.AbstractExecution;
import org.apache.geode.internal.security.IntegratedSecurityService;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.CommandResultException;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.ResultData;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class LuceneIndexCommands
implements GfshCommand {
    private static final LuceneCreateIndexFunction createIndexFunction = new LuceneCreateIndexFunction();
    private static final LuceneDescribeIndexFunction describeIndexFunction = new LuceneDescribeIndexFunction();
    private static final LuceneSearchIndexFunction searchIndexFunction = new LuceneSearchIndexFunction();
    private static final LuceneDestroyIndexFunction destroyIndexFunction = new LuceneDestroyIndexFunction();
    private List<LuceneSearchResults> searchResults = null;
    private SecurityService securityService = IntegratedSecurityService.getSecurityService();

    @CliCommand(value={"list lucene indexes"}, help="Display the list of lucene indexes created for all members.")
    @CliMetaData(relatedTopic={"Region", "Data"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result listIndex(@CliOption(key={"with-stats"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Display lucene index stats") boolean stats) {
        try {
            return this.toTabularResult(this.getIndexListing(), stats);
        }
        catch (FunctionInvocationTargetException ignore) {
            return ResultBuilder.createGemFireErrorResult((String)CliStrings.format((String)"Could not execute \" {0} \", please try again ", (Object)"list lucene indexes"));
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            this.getCache().getLogger().info(t);
            return ResultBuilder.createGemFireErrorResult((String)String.format("An error occurred while collecting all lucene index information across the Geode cluster: %1$s", this.toString(t, this.isDebugging())));
        }
    }

    protected List<LuceneIndexDetails> getIndexListing() {
        Execution functionExecutor = this.getMembersFunctionExecutor(this.getMembers(this.getCache()));
        if (functionExecutor instanceof AbstractExecution) {
            ((AbstractExecution)functionExecutor).setIgnoreDepartedMembers(true);
        }
        ResultCollector resultsCollector = functionExecutor.execute((Function)new LuceneListIndexFunction());
        List results = (List)resultsCollector.getResult();
        List<LuceneIndexDetails> sortedResults = results.stream().flatMap(set -> set.stream()).sorted().collect(Collectors.toList());
        LinkedHashSet<LuceneIndexDetails> uniqResults = new LinkedHashSet<LuceneIndexDetails>();
        uniqResults.addAll(sortedResults);
        sortedResults.clear();
        sortedResults.addAll(uniqResults);
        return sortedResults;
    }

    protected Result toTabularResult(List<LuceneIndexDetails> indexDetailsList, boolean stats) {
        if (!indexDetailsList.isEmpty()) {
            TabularResultData indexData = ResultBuilder.createTabularResultData();
            for (LuceneIndexDetails indexDetails : indexDetailsList) {
                indexData.accumulate("Index Name", (Object)indexDetails.getIndexName());
                indexData.accumulate("Region Path", (Object)indexDetails.getRegionPath());
                indexData.accumulate("Server Name", (Object)indexDetails.getServerName());
                indexData.accumulate("Indexed Fields", (Object)indexDetails.getSearchableFieldNamesString());
                indexData.accumulate("Field Analyzer", (Object)indexDetails.getFieldAnalyzersString());
                indexData.accumulate("Status", (Object)(indexDetails.getInitialized() ? "Initialized" : "Defined"));
                if (!stats) continue;
                if (!indexDetails.getInitialized()) {
                    indexData.accumulate("Query Executions", (Object)"NA");
                    indexData.accumulate("Updates", (Object)"NA");
                    indexData.accumulate("Commits", (Object)"NA");
                    indexData.accumulate("Documents", (Object)"NA");
                    continue;
                }
                indexData.accumulate("Query Executions", (Object)indexDetails.getIndexStats().get("queryExecutions"));
                indexData.accumulate("Updates", (Object)indexDetails.getIndexStats().get("updates"));
                indexData.accumulate("Commits", (Object)indexDetails.getIndexStats().get("commits"));
                indexData.accumulate("Documents", (Object)indexDetails.getIndexStats().get("documents"));
            }
            return ResultBuilder.buildResult((ResultData)indexData);
        }
        return ResultBuilder.createInfoResult((String)"No lucene indexes found");
    }

    @CliCommand(value={"create lucene index"}, help="Create a lucene index that can be used to execute queries.")
    @CliMetaData(relatedTopic={"Region", "Data"})
    public Result createIndex(@CliOption(key={"name"}, mandatory=true, help="Name of the lucene index to create.") String indexName, @CliOption(key={"region"}, mandatory=true, optionContext="geode.converter.region.path:disable-string-converter", help="Name/Path of the region on which to create the lucene index.") String regionPath, @CliOption(key={"field"}, mandatory=true, help="Fields on the region values which are stored in the lucene index.\nUse __REGION_VALUE_FIELD if the entire region value should be indexed.\n__REGION_VALUE_FIELD is valid only if the region values are strings or numbers.") String[] fields, @CliOption(key={"analyzer"}, help="Type of the analyzer for each field.\nUse the case sensitive keyword DEFAULT or leave an analyzer blank to use the default standard analyzer.") String[] analyzers) {
        Result result;
        Object xmlEntity = null;
        this.securityService.authorizeRegionManage(regionPath);
        try {
            InternalCache cache = this.getCache();
            String[] trimmedFields = (String[])Arrays.stream(fields).map(field -> field.trim()).toArray(String[]::new);
            LuceneIndexInfo indexInfo = new LuceneIndexInfo(indexName, regionPath, trimmedFields, analyzers);
            ResultCollector<?, ?> rc = this.executeFunctionOnAllMembers((Function)createIndexFunction, indexInfo);
            List funcResults = (List)rc.getResult();
            TabularResultData tabularResult = ResultBuilder.createTabularResultData();
            for (CliFunctionResult cliFunctionResult : funcResults) {
                tabularResult.accumulate("Member", (Object)cliFunctionResult.getMemberIdOrName());
                if (cliFunctionResult.isSuccessful()) {
                    tabularResult.accumulate("Status", (Object)"Successfully created lucene index");
                    continue;
                }
                tabularResult.accumulate("Status", (Object)("Failed: " + cliFunctionResult.getMessage()));
            }
            result = ResultBuilder.buildResult((ResultData)tabularResult);
        }
        catch (IllegalArgumentException iae) {
            LogWrapper.getInstance().info(iae.getMessage());
            result = ResultBuilder.createUserErrorResult((String)iae.getMessage());
        }
        catch (CommandResultException crex) {
            result = crex.getResult();
        }
        catch (Exception e) {
            result = ResultBuilder.createGemFireErrorResult((String)e.getMessage());
        }
        return result;
    }

    @CliCommand(value={"describe lucene index"}, help="Display the description of lucene indexes created for all members.")
    @CliMetaData(relatedTopic={"Region", "Data"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result describeIndex(@CliOption(key={"name"}, mandatory=true, help="Name of the lucene index to describe.") String indexName, @CliOption(key={"region"}, mandatory=true, optionContext="geode.converter.region.path:disable-string-converter", help="Name/Path of the region defining the lucene index to be described.") String regionPath) {
        try {
            LuceneIndexInfo indexInfo = new LuceneIndexInfo(indexName, regionPath);
            return this.toTabularResult(this.getIndexDetails(indexInfo), true);
        }
        catch (FunctionInvocationTargetException ignore) {
            return ResultBuilder.createGemFireErrorResult((String)CliStrings.format((String)"Could not execute \" {0} \", please try again ", (Object)"describe lucene index"));
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (IllegalArgumentException e) {
            return ResultBuilder.createInfoResult((String)e.getMessage());
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            this.getCache().getLogger().info(t);
            return ResultBuilder.createGemFireErrorResult((String)String.format("An error occurred while collecting lucene index information across the Geode cluster: %1$s", this.toString(t, this.isDebugging())));
        }
    }

    protected List<LuceneIndexDetails> getIndexDetails(LuceneIndexInfo indexInfo) throws Exception {
        ResultCollector<?, ?> rc = this.executeFunctionOnRegion((Function)describeIndexFunction, indexInfo, true);
        List funcResults = (List)rc.getResult();
        return funcResults.stream().filter(indexDetails -> indexDetails != null).collect(Collectors.toList());
    }

    @CliCommand(value={"search lucene"}, help="Search lucene index")
    @CliMetaData(relatedTopic={"Region", "Data"})
    @ResourceOperation(resource=ResourcePermission.Resource.DATA, operation=ResourcePermission.Operation.WRITE)
    public Result searchIndex(@CliOption(key={"name"}, mandatory=true, help="Name of the lucene index to search.") String indexName, @CliOption(key={"region"}, mandatory=true, optionContext="geode.converter.region.path:disable-string-converter", help="Name/Path of the region defining the lucene index to be searched.") String regionPath, @CliOption(key={"queryStrings"}, mandatory=true, help="Query string to search the lucene index") String queryString, @CliOption(key={"defaultField"}, mandatory=true, help="Default field to search in") String defaultField, @CliOption(key={"limit"}, unspecifiedDefaultValue="-1", help="Number of search results needed") int limit, @CliOption(key={"keys-only"}, unspecifiedDefaultValue="false", help="Return only keys of search results.") boolean keysOnly) {
        try {
            LuceneQueryInfo queryInfo = new LuceneQueryInfo(indexName, regionPath, queryString, defaultField, limit, keysOnly);
            int pageSize = Integer.MAX_VALUE;
            this.searchResults = this.getSearchResults(queryInfo);
            return this.displayResults(pageSize, keysOnly);
        }
        catch (FunctionInvocationTargetException ignore) {
            return ResultBuilder.createGemFireErrorResult((String)CliStrings.format((String)"Could not execute \" {0} \", please try again ", (Object)"search lucene"));
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (IllegalArgumentException e) {
            return ResultBuilder.createInfoResult((String)e.getMessage());
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            this.getCache().getLogger().info(t);
            return ResultBuilder.createGemFireErrorResult((String)String.format("An error occurred while searching lucene index across the Geode cluster: %1$s", this.toString(t, this.isDebugging())));
        }
    }

    @CliCommand(value={"destroy lucene index"}, help="Destroy the lucene index.")
    @CliMetaData(relatedTopic={"Region", "Data"})
    public Result destroyIndex(@CliOption(key={"name"}, help="Name of the lucene index to destroy.") String indexName, @CliOption(key={"region"}, mandatory=true, optionContext="geode.converter.region.path:disable-string-converter", help="Name of the region defining the lucene index to be destroyed.") String regionPath) {
        Result result;
        if (StringUtils.isBlank((String)regionPath) || regionPath.equals("/")) {
            return ResultBuilder.createInfoResult((String)CliStrings.format((String)"Region cannot be empty.", (Object[])new Object[0]));
        }
        if (indexName != null && StringUtils.isEmpty((String)indexName)) {
            return ResultBuilder.createInfoResult((String)CliStrings.format((String)"Index cannot be empty.", (Object[])new Object[0]));
        }
        this.securityService.authorizeRegionManage(regionPath);
        try {
            ArrayList<CliFunctionResult> accumulatedResults = new ArrayList<CliFunctionResult>();
            XmlEntity xmlEntity = this.executeDestroyIndexFunction(accumulatedResults, indexName, regionPath);
            result = this.getDestroyIndexResult(accumulatedResults, indexName, regionPath);
            if (xmlEntity != null) {
                this.persistClusterConfiguration(result, () -> this.getSharedConfiguration().deleteXmlEntity(xmlEntity, null));
            }
        }
        catch (FunctionInvocationTargetException ignore) {
            result = ResultBuilder.createGemFireErrorResult((String)CliStrings.format((String)"Could not execute \" {0} \", please try again ", (Object)"destroy lucene index"));
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (IllegalArgumentException e) {
            result = ResultBuilder.createInfoResult((String)e.getMessage());
        }
        catch (Throwable t) {
            t.printStackTrace();
            SystemFailure.checkFailure();
            this.getCache().getLogger().warning("An unexpected exception occurred while destroying lucene index:", t);
            result = ResultBuilder.createGemFireErrorResult((String)t.getMessage());
        }
        return result;
    }

    private XmlEntity executeDestroyIndexFunction(List<CliFunctionResult> accumulatedResults, String indexName, String regionPath) {
        XmlEntity xmlEntity = null;
        InternalCache cache = this.getCache();
        Set<DistributedMember> regionMembers = this.getRegionMembers(cache, regionPath);
        Set<DistributedMember> normalMembers = this.getNormalMembers(cache);
        LuceneDestroyIndexInfo indexInfo = new LuceneDestroyIndexInfo(indexName, regionPath);
        if (regionMembers.isEmpty()) {
            indexInfo.setDefinedDestroyOnly(true);
            ResultCollector<?, ?> rc = this.executeFunction(destroyIndexFunction, indexInfo, normalMembers);
            accumulatedResults.addAll((List)rc.getResult());
        } else {
            indexInfo.setDefinedDestroyOnly(false);
            HashSet<DistributedMember> singleMember = new HashSet<DistributedMember>();
            singleMember.add(regionMembers.iterator().next());
            ResultCollector<?, ?> rc = this.executeFunction(destroyIndexFunction, indexInfo, singleMember);
            List cliFunctionResults = (List)rc.getResult();
            CliFunctionResult cliFunctionResult = (CliFunctionResult)cliFunctionResults.get(0);
            xmlEntity = cliFunctionResult.getXmlEntity();
            for (DistributedMember regionMember : regionMembers) {
                accumulatedResults.add(new CliFunctionResult(regionMember.getId(), cliFunctionResult.isSuccessful(), cliFunctionResult.getMessage()));
            }
            if (cliFunctionResult.isSuccessful()) {
                normalMembers.removeAll(regionMembers);
                if (!normalMembers.isEmpty()) {
                    indexInfo.setDefinedDestroyOnly(true);
                    rc = this.executeFunction(destroyIndexFunction, indexInfo, normalMembers);
                    accumulatedResults.addAll((List)rc.getResult());
                }
            }
        }
        return xmlEntity;
    }

    protected Set<DistributedMember> getRegionMembers(InternalCache cache, String regionPath) {
        return CliUtil.getMembersForeRegionViaFunction((InternalCache)cache, (String)regionPath, (boolean)true);
    }

    protected Set<DistributedMember> getNormalMembers(InternalCache cache) {
        return CliUtil.getAllNormalMembers((InternalCache)cache);
    }

    private Result getDestroyIndexResult(List<CliFunctionResult> cliFunctionResults, String indexName, String regionPath) {
        TabularResultData tabularResult = ResultBuilder.createTabularResultData();
        for (CliFunctionResult cliFunctionResult : cliFunctionResults) {
            tabularResult.accumulate("Member", (Object)cliFunctionResult.getMemberIdOrName());
            if (cliFunctionResult.isSuccessful()) {
                tabularResult.accumulate("Status", (Object)(indexName == null ? CliStrings.format((String)"Successfully destroyed all lucene indexes from region {0}", (Object[])new Object[]{regionPath}) : CliStrings.format((String)"Successfully destroyed lucene index {0} from region {1}", (Object[])new Object[]{indexName, regionPath})));
                continue;
            }
            tabularResult.accumulate("Status", (Object)cliFunctionResult.getMessage());
        }
        return ResultBuilder.buildResult((ResultData)tabularResult);
    }

    private Result displayResults(int pageSize, boolean keysOnly) throws Exception {
        if (this.searchResults.size() == 0) {
            return ResultBuilder.createInfoResult((String)"No results");
        }
        Gfsh gfsh = this.initGfsh();
        boolean pagination = this.searchResults.size() > pageSize;
        int fromIndex = 0;
        int toIndex = pageSize < this.searchResults.size() ? pageSize : this.searchResults.size();
        int currentPage = 1;
        int totalPages = (int)Math.ceil((float)this.searchResults.size() / (float)pageSize);
        boolean skipDisplay = false;
        String step = null;
        block10: while (true) {
            if (!skipDisplay) {
                CommandResult commandResult = (CommandResult)this.getResults(fromIndex, toIndex, keysOnly);
                if (!pagination) {
                    return commandResult;
                }
                Gfsh.println();
                while (commandResult.hasNextLine()) {
                    gfsh.printAsInfo(commandResult.nextLine());
                }
                gfsh.printAsInfo("\t\tPage " + currentPage + " of " + totalPages);
                String message = "Press n to move to next page, q to quit and p to previous page : ";
                step = gfsh.interact(message);
            }
            switch (step) {
                case "n": {
                    if (currentPage == totalPages) {
                        gfsh.printAsInfo("No more results to display.");
                        step = gfsh.interact("Press p to move to last page and q to quit.");
                        skipDisplay = true;
                        continue block10;
                    }
                    if (skipDisplay) {
                        skipDisplay = false;
                        continue block10;
                    }
                    ++currentPage;
                    int current = fromIndex;
                    fromIndex = toIndex;
                    toIndex = pageSize + fromIndex >= this.searchResults.size() ? this.searchResults.size() : pageSize + fromIndex;
                    continue block10;
                }
                case "p": {
                    if (currentPage == 1) {
                        gfsh.printAsInfo("At the top of the search results.");
                        step = gfsh.interact("Press n to move to the first page and q to quit.");
                        skipDisplay = true;
                        continue block10;
                    }
                    if (skipDisplay) {
                        skipDisplay = false;
                        continue block10;
                    }
                    --currentPage;
                    int current = fromIndex;
                    toIndex = fromIndex;
                    fromIndex = current - pageSize <= 0 ? 0 : current - pageSize;
                    continue block10;
                }
                case "q": {
                    return ResultBuilder.createInfoResult((String)"Search complete.");
                }
            }
            Gfsh.println((Object)"Invalid option");
        }
    }

    protected Gfsh initGfsh() {
        return Gfsh.getCurrentInstance();
    }

    private List<LuceneSearchResults> getSearchResults(LuceneQueryInfo queryInfo) throws Exception {
        String[] groups = new String[]{};
        ResultCollector<?, ?> rc = this.executeSearch(queryInfo);
        List functionResults = (List)rc.getResult();
        return functionResults.stream().flatMap(set -> set.stream()).sorted().collect(Collectors.toList());
    }

    private Result getResults(int fromIndex, int toIndex, boolean keysonly) throws Exception {
        TabularResultData data = ResultBuilder.createTabularResultData();
        for (int i = fromIndex; i < toIndex; ++i) {
            if (!this.searchResults.get(i).getExeptionFlag()) {
                data.accumulate("key", (Object)this.searchResults.get(i).getKey());
                if (keysonly) continue;
                data.accumulate("value", (Object)this.searchResults.get(i).getValue());
                data.accumulate("score", (Object)Float.valueOf(this.searchResults.get(i).getScore()));
                continue;
            }
            throw new Exception(this.searchResults.get(i).getExceptionMessage());
        }
        return ResultBuilder.buildResult((ResultData)data);
    }

    protected ResultCollector<?, ?> executeFunctionOnAllMembers(Function function, LuceneFunctionSerializable functionArguments) throws IllegalArgumentException, CommandResultException {
        Set targetMembers = CliUtil.getAllNormalMembers((InternalCache)this.getCache());
        return this.executeFunction(function, functionArguments, targetMembers);
    }

    protected ResultCollector<?, ?> executeSearch(LuceneQueryInfo queryInfo) throws Exception {
        return this.executeFunctionOnRegion((Function)searchIndexFunction, queryInfo, false);
    }

    protected ResultCollector<?, ?> executeFunctionOnRegion(Function function, LuceneFunctionSerializable functionArguments, boolean returnAllMembers) {
        Set targetMembers = CliUtil.getMembersForeRegionViaFunction((InternalCache)this.getCache(), (String)functionArguments.getRegionPath(), (boolean)returnAllMembers);
        if (targetMembers.isEmpty()) {
            throw new IllegalArgumentException(CliStrings.format((String)"Could not find any members defining region {0}.", (Object[])new Object[]{functionArguments.getRegionPath()}));
        }
        return this.executeFunction(function, functionArguments, targetMembers);
    }

    protected ResultCollector<?, ?> executeFunction(Function function, LuceneFunctionSerializable functionArguments, Set<DistributedMember> targetMembers) {
        return CliUtil.executeFunction((Function)function, (Object)functionArguments, targetMembers);
    }

    @CliAvailabilityIndicator(value={"search lucene", "create lucene index", "describe lucene index", "list lucene indexes", "destroy lucene index"})
    public boolean indexCommandsAvailable() {
        return !CliUtil.isGfshVM() || this.getGfsh() != null && this.getGfsh().isConnectedAndReady();
    }
}

