/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.lucene.LuceneIndex;
import org.apache.geode.cache.lucene.LuceneQueryException;
import org.apache.geode.cache.lucene.LuceneQueryProvider;
import org.apache.geode.cache.lucene.internal.LuceneIndexImpl;
import org.apache.geode.internal.serialization.DataSerializableFixedID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import org.apache.lucene.queryparser.flexible.standard.StandardQueryParser;
import org.apache.lucene.search.Query;

public class StringQueryProvider
implements LuceneQueryProvider,
DataSerializableFixedID {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LogService.getLogger();
    private String query;
    private transient Query luceneQuery;
    private String defaultField;

    public StringQueryProvider() {
        this(null, null);
    }

    public StringQueryProvider(String query, String defaultField) {
        this.query = query;
        this.defaultField = defaultField;
    }

    @Override
    public synchronized Query getQuery(LuceneIndex index) throws LuceneQueryException {
        if (this.luceneQuery == null) {
            LuceneIndexImpl indexImpl = (LuceneIndexImpl)index;
            StandardQueryParser parser = new StandardQueryParser(indexImpl.getAnalyzer());
            parser.setAllowLeadingWildcard(true);
            try {
                this.luceneQuery = parser.parse(this.query, this.defaultField);
                if (logger.isDebugEnabled()) {
                    logger.debug("User query " + this.query + " is parsed to be: " + this.luceneQuery);
                }
            }
            catch (QueryNodeException e) {
                logger.warn("Caught the following exception attempting parse query '" + this.query + "': ", (Throwable)e);
                throw new LuceneQueryException(String.format("Parsing query %s failed due to: %s", "'" + this.query + "'", e.getMessage()));
            }
        }
        return this.luceneQuery;
    }

    public String getQueryString() {
        return this.query;
    }

    public Version[] getSerializationVersions() {
        return null;
    }

    public int getDSFID() {
        return 2172;
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        DataSerializer.writeString((String)this.query, (DataOutput)out);
        DataSerializer.writeString((String)this.defaultField, (DataOutput)out);
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        this.query = DataSerializer.readString((DataInput)in);
        this.defaultField = DataSerializer.readString((DataInput)in);
    }
}

