/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.repository.serializer;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apache.geode.cache.lucene.LuceneIndex;
import org.apache.geode.cache.lucene.LuceneSerializer;
import org.apache.geode.cache.lucene.internal.repository.serializer.SerializerUtil;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.Document;

class ReflectionLuceneSerializer
implements LuceneSerializer {
    private Field[] fields;
    private static final Logger logger = LogService.getLogger();

    public ReflectionLuceneSerializer(Class<? extends Object> clazz, String[] indexedFields) {
        HashSet<String> fieldSet = new HashSet<String>(Arrays.asList(indexedFields));
        ArrayList<Field> foundFields = new ArrayList<Field>();
        while (clazz != Object.class) {
            for (Field field : clazz.getDeclaredFields()) {
                Class<?> type = field.getType();
                if (!fieldSet.contains(field.getName()) || !SerializerUtil.isSupported(type)) continue;
                field.setAccessible(true);
                foundFields.add(field);
            }
            clazz = clazz.getSuperclass();
        }
        this.fields = foundFields.toArray(new Field[foundFields.size()]);
    }

    public Collection<Document> toDocuments(LuceneIndex index, Object value) {
        Document doc = new Document();
        for (Field field : this.fields) {
            try {
                Object fieldValue = field.get(value);
                if (fieldValue == null) continue;
                SerializerUtil.addField(doc, field.getName(), fieldValue);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("ReflectionLuceneSerializer.toDocument:" + doc);
        }
        return Collections.singleton(doc);
    }
}

