/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.distributed;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.geode.cache.lucene.internal.distributed.EntryScore;
import org.apache.geode.internal.serialization.DataSerializableFixedID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.Version;

public class TopEntries<K>
implements DataSerializableFixedID {
    private List<EntryScore<K>> hits = new ArrayList<EntryScore<K>>();
    private int limit;
    final Comparator<EntryScore<K>> comparator = new EntryScoreComparator();

    public TopEntries() {
        this(100);
    }

    public TopEntries(int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException();
        }
        this.limit = limit;
    }

    public void addHit(EntryScore<K> entry) {
        EntryScore<K> lastEntry;
        if (this.hits.size() > 0 && this.comparator.compare(lastEntry = this.hits.get(this.hits.size() - 1), entry) < 0) {
            throw new IllegalArgumentException();
        }
        if (this.hits.size() >= this.limit) {
            return;
        }
        this.hits.add(entry);
    }

    public int size() {
        return this.hits.size();
    }

    public List<EntryScore<K>> getHits() {
        return this.hits;
    }

    public int getLimit() {
        return this.limit;
    }

    public Version[] getSerializationVersions() {
        return null;
    }

    public int getDSFID() {
        return 2175;
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        out.writeInt(this.limit);
        context.getSerializer().writeObject(this.hits, out);
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        this.limit = in.readInt();
        this.hits = (List)context.getDeserializer().readObject(in);
    }

    class EntryScoreComparator
    implements Comparator<EntryScore<K>> {
        EntryScoreComparator() {
        }

        @Override
        public int compare(EntryScore<K> o1, EntryScore<K> o2) {
            return Float.compare(o1.getScore(), o2.getScore());
        }
    }
}

