/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.lucene.LuceneIndexDestroyedException;
import org.apache.geode.cache.lucene.LuceneSerializer;
import org.apache.geode.cache.lucene.internal.InternalLuceneIndex;
import org.apache.geode.cache.lucene.internal.LuceneIndexCreationProfile;
import org.apache.geode.cache.lucene.internal.LuceneServiceImpl;
import org.apache.geode.internal.cache.CacheServiceProfile;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.RegionListener;
import org.apache.geode.internal.logging.LogService;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;

public class LuceneRegionListener
implements RegionListener {
    private final LuceneServiceImpl service;
    private final InternalCache cache;
    private final String indexName;
    private final String regionPath;
    private final Analyzer analyzer;
    private final Map<String, Analyzer> fieldAnalyzers;
    private final String[] fields;
    private LuceneSerializer serializer;
    private InternalLuceneIndex luceneIndex;
    private AtomicBoolean beforeCreateInvoked = new AtomicBoolean();
    private AtomicBoolean afterCreateInvoked = new AtomicBoolean();
    private static final Logger logger = LogService.getLogger();

    public LuceneRegionListener(LuceneServiceImpl service, InternalCache cache, String indexName, String regionPath, String[] fields, Analyzer analyzer, Map<String, Analyzer> fieldAnalyzers, LuceneSerializer serializer) {
        this.service = service;
        this.cache = cache;
        this.indexName = indexName;
        this.regionPath = regionPath;
        this.fields = fields;
        this.analyzer = analyzer;
        this.fieldAnalyzers = fieldAnalyzers;
        this.serializer = serializer;
    }

    public String getRegionPath() {
        return this.regionPath;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public RegionAttributes beforeCreate(Region parent, String regionName, RegionAttributes attrs, InternalRegionArguments internalRegionArgs) {
        String path;
        RegionAttributes updatedRA = attrs;
        String string = path = parent == null ? "/" + regionName : parent.getFullPath() + "/" + regionName;
        if (path.equals(this.regionPath) && this.beforeCreateInvoked.compareAndSet(false, true)) {
            LuceneServiceImpl.validateRegionAttributes(attrs);
            String aeqId = LuceneServiceImpl.getUniqueIndexName(this.indexName, this.regionPath);
            if (!attrs.getAsyncEventQueueIds().contains(aeqId)) {
                AttributesFactory af = new AttributesFactory(attrs);
                af.addAsyncEventQueueId(aeqId);
                updatedRA = af.create();
            }
            internalRegionArgs.addCacheServiceProfile((CacheServiceProfile)new LuceneIndexCreationProfile(this.indexName, this.regionPath, this.fields, this.analyzer, this.fieldAnalyzers, this.serializer));
            this.luceneIndex = this.service.beforeDataRegionCreated(this.indexName, this.regionPath, attrs, this.analyzer, this.fieldAnalyzers, aeqId, this.serializer, this.fields);
            internalRegionArgs.addInternalAsyncEventQueueId(aeqId);
        }
        return updatedRA;
    }

    public void afterCreate(Region region) {
        if (region.getFullPath().equals(this.regionPath) && this.afterCreateInvoked.compareAndSet(false, true)) {
            try {
                this.service.afterDataRegionCreated(this.luceneIndex);
            }
            catch (LuceneIndexDestroyedException e) {
                logger.warn(String.format("Lucene index %s on region %s was destroyed while being created", this.indexName, this.regionPath));
                return;
            }
            this.service.createLuceneIndexOnDataRegion((PartitionedRegion)region, this.luceneIndex);
        }
    }

    public void beforeDestroyed(Region region) {
        if (region.getFullPath().equals(this.regionPath)) {
            this.service.beforeRegionDestroyed(region);
        }
    }

    public void cleanupFailedInitialization(Region region) {
        this.beforeCreateInvoked.set(false);
        this.afterCreateInvoked.set(false);
        if (region.getFullPath().equals(this.regionPath)) {
            this.service.cleanupFailedInitialization(region);
        }
    }
}

