/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal;

import java.io.File;
import java.io.IOException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.lucene.internal.IndexRepositoryFactory;
import org.apache.geode.cache.lucene.internal.LuceneIndexImpl;
import org.apache.geode.cache.lucene.internal.LuceneRawIndex;
import org.apache.geode.cache.lucene.internal.LuceneServiceImpl;
import org.apache.geode.cache.lucene.internal.repository.IndexRepository;
import org.apache.geode.cache.lucene.internal.repository.IndexRepositoryImpl;
import org.apache.geode.cache.lucene.internal.repository.serializer.LuceneSerializer;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.RAMDirectory;

public class RawIndexRepositoryFactory
extends IndexRepositoryFactory {
    @Override
    public IndexRepository createIndexRepository(Integer bucketId, LuceneSerializer serializer, LuceneIndexImpl index, PartitionedRegion userRegion) throws IOException {
        LuceneRawIndex indexForRaw = (LuceneRawIndex)index;
        BucketRegion dataBucket = this.getMatchingBucket(userRegion, bucketId);
        RAMDirectory dir = null;
        if (indexForRaw.withPersistence()) {
            String bucketLocation = LuceneServiceImpl.getUniqueIndexName(index.getName(), index.getRegionPath() + "_" + bucketId);
            File location = new File(index.getName(), bucketLocation);
            if (!location.exists()) {
                location.mkdirs();
            }
            dir = new NIOFSDirectory(location.toPath());
        } else {
            dir = new RAMDirectory();
        }
        IndexWriterConfig config = new IndexWriterConfig(indexForRaw.getAnalyzer());
        IndexWriter writer = new IndexWriter((Directory)dir, config);
        return new IndexRepositoryImpl(null, writer, serializer, indexForRaw.getIndexStats(), (Region<?, ?>)dataBucket);
    }
}

