/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.lucene.internal.xml;

import com.gemstone.gemfire.cache.CacheXmlException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.lucene.internal.xml.LuceneIndexCreation;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.extension.Extension;
import com.gemstone.gemfire.internal.cache.xmlcache.AbstractXmlParser;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionCreation;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import org.apache.lucene.analysis.Analyzer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LuceneXmlParser
extends AbstractXmlParser {
    public String getNamspaceUri() {
        return "http://geode.apache.org/schema/lucene";
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (!"http://geode.apache.org/schema/lucene".equals(uri)) {
            return;
        }
        if ("index".equals(localName)) {
            this.startIndex(atts);
        }
        if ("field".equals(localName)) {
            this.startField(atts);
        }
    }

    private void startField(Attributes atts) {
        if (this.stack.peek() instanceof StringBuffer) {
            this.stack.pop();
        }
        LuceneIndexCreation creation = (LuceneIndexCreation)this.stack.peek();
        String name = atts.getValue("name");
        String className = atts.getValue("analyzer");
        if (className == null) {
            creation.addField(name);
        } else {
            Analyzer analyzer = this.createAnalyzer(className);
            creation.addFieldAndAnalyzer(name, analyzer);
        }
    }

    private void startIndex(Attributes atts) {
        RegionCreation region = (RegionCreation)this.stack.peek();
        String name = atts.getValue("name");
        LuceneIndexCreation indexCreation = new LuceneIndexCreation();
        indexCreation.setName(name);
        indexCreation.setRegion((Region)region);
        region.getExtensionPoint().addExtension((Extension)indexCreation);
        this.stack.push(indexCreation);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!"http://geode.apache.org/schema/lucene".equals(uri)) {
            return;
        }
        if ("index".equals(localName)) {
            this.endIndex();
        }
    }

    private void endIndex() {
        if (this.stack.peek() instanceof StringBuffer) {
            this.stack.pop();
        }
        this.stack.pop();
    }

    private Analyzer createAnalyzer(String className) {
        Object obj;
        try {
            Class c = InternalDataSerializer.getCachedClass((String)className);
            obj = c.newInstance();
        }
        catch (Exception ex) {
            throw new CacheXmlException(LocalizedStrings.CacheXmlParser_WHILE_INSTANTIATING_A_0.toLocalizedString(new Object[]{className}), (Throwable)ex);
        }
        if (!(obj instanceof Analyzer)) {
            throw new CacheXmlException(LocalizedStrings.LuceneXmlParser_CLASS_0_IS_NOT_AN_INSTANCE_OF_ANALYZER.toLocalizedString(new Object[]{className}));
        }
        return (Analyzer)obj;
    }
}

