/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.lucene.internal.repository.serializer;

import com.gemstone.gemfire.cache.lucene.internal.repository.serializer.LuceneSerializer;
import com.gemstone.gemfire.cache.lucene.internal.repository.serializer.SerializerUtil;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.pdx.PdxInstance;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.Document;

class PdxLuceneSerializer
implements LuceneSerializer {
    private String[] indexedFields;
    private static final Logger logger = LogService.getLogger();

    public PdxLuceneSerializer(String[] indexedFields) {
        this.indexedFields = indexedFields;
    }

    @Override
    public void toDocument(Object value, Document doc) {
        PdxInstance pdx = (PdxInstance)value;
        for (String field : this.indexedFields) {
            Object fieldValue;
            if (!pdx.hasField(field) || (fieldValue = pdx.getField(field)) == null) continue;
            SerializerUtil.addField(doc, field, fieldValue);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("PdxLuceneSerializer.toDocument:" + doc);
        }
    }
}

