/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.lucene.internal.management;

import com.gemstone.gemfire.cache.lucene.LuceneIndex;
import com.gemstone.gemfire.cache.lucene.LuceneService;
import com.gemstone.gemfire.cache.lucene.internal.LuceneIndexImpl;
import com.gemstone.gemfire.cache.lucene.internal.LuceneIndexStats;
import com.gemstone.gemfire.cache.lucene.internal.management.LuceneIndexMetrics;
import java.util.ArrayList;
import java.util.Collection;

public class LuceneServiceBridge {
    private LuceneService service;

    public LuceneServiceBridge(LuceneService service) {
        this.service = service;
    }

    public LuceneIndexMetrics[] listIndexMetrics() {
        Collection<LuceneIndex> indexes = this.service.getAllIndexes();
        LuceneIndexMetrics[] indexMetrics = new LuceneIndexMetrics[indexes.size()];
        int i = 0;
        for (LuceneIndex index : this.service.getAllIndexes()) {
            indexMetrics[i++] = this.getIndexMetrics((LuceneIndexImpl)index);
        }
        return indexMetrics;
    }

    public LuceneIndexMetrics[] listIndexMetrics(String regionPath) {
        if (!regionPath.startsWith("/")) {
            regionPath = "/" + regionPath;
        }
        ArrayList<LuceneIndexMetrics> indexMetrics = new ArrayList<LuceneIndexMetrics>();
        for (LuceneIndex index : this.service.getAllIndexes()) {
            if (!index.getRegionPath().equals(regionPath)) continue;
            indexMetrics.add(this.getIndexMetrics((LuceneIndexImpl)index));
        }
        return indexMetrics.toArray(new LuceneIndexMetrics[indexMetrics.size()]);
    }

    public LuceneIndexMetrics listIndexMetrics(String regionPath, String indexName) {
        LuceneIndexImpl index = (LuceneIndexImpl)this.service.getIndex(indexName, regionPath);
        return index == null ? null : this.getIndexMetrics(index);
    }

    private LuceneIndexMetrics getIndexMetrics(LuceneIndexImpl index) {
        LuceneIndexStats indexStats = index.getIndexStats();
        int queryExecutions = indexStats.getQueryExecutions();
        long queryExecutionTime = indexStats.getQueryExecutionTime();
        int queryExecutionsInProgress = indexStats.getQueryExecutionsInProgress();
        long queryExecutionTotalHits = indexStats.getQueryExecutionTotalHits();
        int updates = indexStats.getUpdates();
        long updateTime = indexStats.getUpdateTime();
        int updatesInProgress = indexStats.getUpdatesInProgress();
        int commits = indexStats.getCommits();
        long commitTime = indexStats.getCommitTime();
        int commitsInProgress = indexStats.getCommitsInProgress();
        int documents = indexStats.getDocuments();
        return new LuceneIndexMetrics(index.getRegionPath(), index.getName(), queryExecutions, queryExecutionTime, queryExecutionsInProgress, queryExecutionTotalHits, updates, updateTime, updatesInProgress, commits, commitTime, commitsInProgress, documents);
    }
}

