/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.lucene.internal.filesystem;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsFactory;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.StatisticsTypeFactory;
import com.gemstone.gemfire.internal.StatisticsTypeFactoryImpl;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;

public class FileSystemStats {
    private static final StatisticsType statsType;
    private static final String statsTypeName = "FileSystemStats";
    private static final String statsTypeDescription = "Statistics about in memory file system implementation";
    private final Statistics stats;
    private static final int readBytesId;
    private static final int writtenBytesId;
    private static final int fileCreatesId;
    private static final int temporaryFileCreatesId;
    private static final int fileDeletesId;
    private static final int fileRenamesId;
    private static final int filesId;
    private static final int chunksId;
    private static final int bytesId;

    public FileSystemStats(StatisticsFactory f, String name) {
        this.stats = f.createAtomicStatistics(statsType, name);
    }

    public void incReadBytes(int delta) {
        this.stats.incLong(readBytesId, (long)delta);
    }

    public void incWrittenBytes(int delta) {
        this.stats.incLong(writtenBytesId, (long)delta);
    }

    public void incFileCreates(int delta) {
        this.stats.incInt(fileCreatesId, delta);
    }

    public void incTemporaryFileCreates(int delta) {
        this.stats.incInt(temporaryFileCreatesId, delta);
    }

    public void incFileDeletes(int delta) {
        this.stats.incInt(fileDeletesId, delta);
    }

    public void incFileRenames(int delta) {
        this.stats.incInt(fileRenamesId, delta);
    }

    public void setFileSupplier(IntSupplier supplier) {
        this.stats.setIntSupplier(filesId, supplier);
    }

    public int getFiles() {
        return this.stats.getInt(filesId);
    }

    public void setChunkSupplier(IntSupplier supplier) {
        this.stats.setIntSupplier(chunksId, supplier);
    }

    public int getChunks() {
        return this.stats.getInt(chunksId);
    }

    public void setBytesSupplier(LongSupplier supplier) {
        this.stats.setLongSupplier(bytesId, supplier);
    }

    public long getBytes() {
        return this.stats.getLong(bytesId);
    }

    static {
        StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
        statsType = f.createType(statsTypeName, statsTypeDescription, new StatisticDescriptor[]{f.createLongCounter("readBytes", "Number of bytes written", "bytes"), f.createLongCounter("writtenBytes", "Number of bytes read", "bytes"), f.createIntCounter("fileCreates", "Number of files created", "files"), f.createIntCounter("temporaryFileCreates", "Number of temporary files created", "files"), f.createIntCounter("fileDeletes", "Number of files deleted", "files"), f.createIntCounter("fileRenames", "Number of files renamed", "files"), f.createIntGauge("files", "Number of files on this member", "files"), f.createIntGauge("chunks", "Number of file chunks on this member", "chunks"), f.createLongGauge("bytes", "Number of bytes on this member", "bytes")});
        readBytesId = statsType.nameToId("readBytes");
        writtenBytesId = statsType.nameToId("writtenBytes");
        fileCreatesId = statsType.nameToId("fileCreates");
        temporaryFileCreatesId = statsType.nameToId("temporaryFileCreates");
        fileDeletesId = statsType.nameToId("fileDeletes");
        fileRenamesId = statsType.nameToId("fileRenames");
        filesId = statsType.nameToId("files");
        chunksId = statsType.nameToId("chunks");
        bytesId = statsType.nameToId("bytes");
    }
}

