/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.lucene.internal.distributed;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.lucene.internal.distributed.EntryScore;
import com.gemstone.gemfire.cache.lucene.internal.distributed.TopEntries;
import com.gemstone.gemfire.cache.lucene.internal.repository.IndexResultCollector;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.Version;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class TopEntriesCollector
implements IndexResultCollector,
DataSerializableFixedID {
    private String name;
    private TopEntries entries;

    public TopEntriesCollector() {
        this(null);
    }

    public TopEntriesCollector(String name) {
        this(name, 100);
    }

    public TopEntriesCollector(String name, int limit) {
        this.name = name;
        this.entries = new TopEntries(limit);
    }

    @Override
    public void collect(Object key, float score) {
        this.collect(new EntryScore<Object>(key, score));
    }

    public void collect(EntryScore entry) {
        this.entries.addHit(entry);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int size() {
        TopEntries entries = this.getEntries();
        return entries == null ? 0 : entries.size();
    }

    public TopEntries getEntries() {
        return this.entries;
    }

    public Version[] getSerializationVersions() {
        return null;
    }

    public int getDSFID() {
        return 2176;
    }

    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeString((String)this.name, (DataOutput)out);
        DataSerializer.writeObject((Object)this.entries, (DataOutput)out);
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.name = DataSerializer.readString((DataInput)in);
        this.entries = (TopEntries)DataSerializer.readObject((DataInput)in);
    }
}

