/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.lucene.internal.cli.functions;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.GemFireCache;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.lucene.LuceneQuery;
import com.gemstone.gemfire.cache.lucene.LuceneQueryException;
import com.gemstone.gemfire.cache.lucene.LuceneService;
import com.gemstone.gemfire.cache.lucene.LuceneServiceProvider;
import com.gemstone.gemfire.cache.lucene.PageableLuceneQueryResults;
import com.gemstone.gemfire.cache.lucene.internal.cli.LuceneQueryInfo;
import com.gemstone.gemfire.cache.lucene.internal.cli.LuceneSearchResults;
import com.gemstone.gemfire.internal.InternalEntity;
import java.util.HashSet;

public class LuceneSearchIndexFunction<K, V>
extends FunctionAdapter
implements InternalEntity {
    protected Cache getCache() {
        return CacheFactory.getAnyInstance();
    }

    public String getId() {
        return LuceneSearchIndexFunction.class.getName();
    }

    public void execute(FunctionContext context) {
        HashSet result = new HashSet();
        Cache cache = this.getCache();
        LuceneQueryInfo queryInfo = (LuceneQueryInfo)context.getArguments();
        LuceneService luceneService = LuceneServiceProvider.get((GemFireCache)this.getCache());
        try {
            if (cache.getRegion(queryInfo.getRegionPath()) != null) {
                LuceneQuery query = luceneService.createLuceneQueryFactory().create(queryInfo.getIndexName(), queryInfo.getRegionPath(), queryInfo.getQueryString(), queryInfo.getDefaultField());
                PageableLuceneQueryResults pageableLuceneQueryResults = query.findPages();
                while (pageableLuceneQueryResults.hasNext()) {
                    Object page = pageableLuceneQueryResults.next();
                    page.stream().forEach(searchResult -> result.add(new LuceneSearchResults(searchResult.getKey().toString(), searchResult.getValue().toString(), searchResult.getScore())));
                }
            }
            context.getResultSender().lastResult(result);
        }
        catch (LuceneQueryException e) {
            context.getResultSender().lastResult((Object)e);
        }
    }
}

