/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.lucene.internal.cli.functions;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.GemFireCache;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.lucene.LuceneService;
import com.gemstone.gemfire.cache.lucene.LuceneServiceProvider;
import com.gemstone.gemfire.cache.lucene.internal.cli.LuceneIndexInfo;
import com.gemstone.gemfire.cache.lucene.internal.cli.functions.LuceneListIndexFunction;
import com.gemstone.gemfire.internal.InternalEntity;
import com.gemstone.gemfire.management.internal.cli.CliUtil;
import com.gemstone.gemfire.management.internal.cli.functions.CliFunctionResult;
import com.gemstone.gemfire.management.internal.cli.i18n.CliStrings;
import com.gemstone.gemfire.management.internal.configuration.domain.XmlEntity;
import java.util.HashMap;
import org.apache.lucene.analysis.Analyzer;

public class LuceneCreateIndexFunction
extends FunctionAdapter
implements InternalEntity {
    protected Cache getCache() {
        return CacheFactory.getAnyInstance();
    }

    public String getId() {
        return LuceneListIndexFunction.class.getName();
    }

    public void execute(FunctionContext context) {
        String memberId = null;
        try {
            LuceneIndexInfo indexInfo = (LuceneIndexInfo)context.getArguments();
            Cache cache = this.getCache();
            memberId = cache.getDistributedSystem().getDistributedMember().getId();
            LuceneService service = LuceneServiceProvider.get((GemFireCache)cache);
            String[] fields = indexInfo.getSearchableFieldNames();
            String[] analyzerName = indexInfo.getFieldAnalyzers();
            if (analyzerName == null || analyzerName.length == 0) {
                service.createIndex(indexInfo.getIndexName(), indexInfo.getRegionPath(), fields);
            } else {
                HashMap<String, Analyzer> fieldAnalyzer = new HashMap<String, Analyzer>();
                for (int i = 0; i < fields.length; ++i) {
                    Analyzer analyzer = this.toAnalyzer(analyzerName[i]);
                    fieldAnalyzer.put(fields[i], analyzer);
                }
                service.createIndex(indexInfo.getIndexName(), indexInfo.getRegionPath(), fieldAnalyzer);
            }
            XmlEntity xmlEntity = null;
            context.getResultSender().lastResult((Object)new CliFunctionResult(memberId, xmlEntity));
        }
        catch (Exception e) {
            String exceptionMessage = CliStrings.format((String)"Exception : {0} , Message : {1}", (Object[])new Object[]{e.getClass().getName(), e.getMessage()});
            context.getResultSender().lastResult((Object)new CliFunctionResult(memberId, (Throwable)e, e.getMessage()));
        }
    }

    private Analyzer toAnalyzer(String className) {
        Class clazz = CliUtil.forName((String)className, (String)"analyzer");
        return (Analyzer)CliUtil.newInstance((Class)clazz, (String)"analyzer");
    }
}

