/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.lucene.internal.cli;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionInvocationTargetException;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.cache.lucene.internal.cli.LuceneIndexDetails;
import com.gemstone.gemfire.cache.lucene.internal.cli.LuceneIndexInfo;
import com.gemstone.gemfire.cache.lucene.internal.cli.LuceneQueryInfo;
import com.gemstone.gemfire.cache.lucene.internal.cli.LuceneSearchResults;
import com.gemstone.gemfire.cache.lucene.internal.cli.functions.LuceneCreateIndexFunction;
import com.gemstone.gemfire.cache.lucene.internal.cli.functions.LuceneDescribeIndexFunction;
import com.gemstone.gemfire.cache.lucene.internal.cli.functions.LuceneListIndexFunction;
import com.gemstone.gemfire.cache.lucene.internal.cli.functions.LuceneSearchIndexFunction;
import com.gemstone.gemfire.internal.cache.execute.AbstractExecution;
import com.gemstone.gemfire.internal.security.GeodeSecurityUtil;
import com.gemstone.gemfire.management.cli.CliMetaData;
import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.CliUtil;
import com.gemstone.gemfire.management.internal.cli.commands.AbstractCommandsSupport;
import com.gemstone.gemfire.management.internal.cli.functions.CliFunctionResult;
import com.gemstone.gemfire.management.internal.cli.i18n.CliStrings;
import com.gemstone.gemfire.management.internal.cli.result.CommandResultException;
import com.gemstone.gemfire.management.internal.cli.result.ResultBuilder;
import com.gemstone.gemfire.management.internal.cli.result.ResultData;
import com.gemstone.gemfire.management.internal.cli.result.TabularResultData;
import com.gemstone.gemfire.management.internal.security.ResourceOperation;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.geode.security.GeodePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class LuceneIndexCommands
extends AbstractCommandsSupport {
    private static final LuceneCreateIndexFunction createIndexFunction = new LuceneCreateIndexFunction();
    private static final LuceneDescribeIndexFunction describeIndexFunction = new LuceneDescribeIndexFunction();
    private static final LuceneSearchIndexFunction searchIndexFunction = new LuceneSearchIndexFunction();

    @CliCommand(value={"list lucene indexes"}, help="Display the list of lucene indexes created for all members.")
    @CliMetaData(shellOnly=false, relatedTopic={"Region", "Data"})
    @ResourceOperation(resource=GeodePermission.Resource.CLUSTER, operation=GeodePermission.Operation.READ)
    public Result listIndex(@CliOption(key={"with-stats"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Display lucene index stats") boolean stats) {
        try {
            return this.toTabularResult(this.getIndexListing(), stats);
        }
        catch (FunctionInvocationTargetException ignore) {
            return ResultBuilder.createGemFireErrorResult((String)CliStrings.format((String)"Could not execute \" {0} \", please try again ", (Object)"list lucene indexes"));
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            this.getCache().getLogger().error(t);
            return ResultBuilder.createGemFireErrorResult((String)String.format("An error occurred while collecting all lucene index information across the Geode cluster: %1$s", LuceneIndexCommands.toString((Throwable)t, (boolean)this.isDebugging())));
        }
    }

    protected List<LuceneIndexDetails> getIndexListing() {
        Execution functionExecutor = this.getMembersFunctionExecutor(this.getMembers(this.getCache()));
        if (functionExecutor instanceof AbstractExecution) {
            ((AbstractExecution)functionExecutor).setIgnoreDepartedMembers(true);
        }
        ResultCollector resultsCollector = functionExecutor.execute((Function)new LuceneListIndexFunction());
        List results = (List)resultsCollector.getResult();
        return results.stream().flatMap(set -> set.stream()).sorted().collect(Collectors.toList());
    }

    protected Result toTabularResult(List<LuceneIndexDetails> indexDetailsList, boolean stats) {
        if (!indexDetailsList.isEmpty()) {
            TabularResultData indexData = ResultBuilder.createTabularResultData();
            for (LuceneIndexDetails indexDetails : indexDetailsList) {
                indexData.accumulate("Index Name", (Object)indexDetails.getIndexName());
                indexData.accumulate("Region Path", (Object)indexDetails.getRegionPath());
                indexData.accumulate("Indexed Fields", (Object)indexDetails.getSearchableFieldNamesString());
                indexData.accumulate("Field Analyzer", (Object)indexDetails.getFieldAnalyzersString());
                if (!stats) continue;
                indexData.accumulate("Query Executions", (Object)indexDetails.getIndexStats().get("queryExecutions"));
                indexData.accumulate("Updates", (Object)indexDetails.getIndexStats().get("updates"));
                indexData.accumulate("Commits", (Object)indexDetails.getIndexStats().get("commits"));
                indexData.accumulate("Documents", (Object)indexDetails.getIndexStats().get("documents"));
            }
            return ResultBuilder.buildResult((ResultData)indexData);
        }
        return ResultBuilder.createInfoResult((String)"No lucene indexes found");
    }

    @CliCommand(value={"create lucene index"}, help="Create a lucene index that can be used to execute queries.")
    @CliMetaData(shellOnly=false, relatedTopic={"Region", "Data"}, writesToSharedConfiguration=true)
    public Result createIndex(@CliOption(key={"name"}, mandatory=true, help="Name of the lucene index to create.") String indexName, @CliOption(key={"region"}, mandatory=true, optionContext="converter.hint.region.path", help="Name/Path of the region where the lucene index is created on.") String regionPath, @CliOption(key={"field"}, mandatory=true, help="fields on the region values which are stored in the lucene index.") @CliMetaData(valueSeparator=",") String[] fields, @CliOption(key={"analyzer"}, mandatory=false, unspecifiedDefaultValue="__NULL__", help="Type of the analyzer for each field.") @CliMetaData(valueSeparator=",") String[] analyzers, @CliOption(key={"group"}, optionContext="converter.hint.member.groups", unspecifiedDefaultValue="__NULL__", help="Group of members in which the lucene index will be created.") @CliMetaData(valueSeparator=",") String[] groups) {
        Result result = null;
        Object xmlEntity = null;
        GeodeSecurityUtil.authorizeRegionManage((String)regionPath);
        try {
            Cache cache = this.getCache();
            LuceneIndexInfo indexInfo = new LuceneIndexInfo(indexName, regionPath, fields, analyzers);
            ResultCollector<?, ?> rc = this.executeFunctionOnGroups((FunctionAdapter)createIndexFunction, groups, indexInfo);
            List funcResults = (List)rc.getResult();
            TabularResultData tabularResult = ResultBuilder.createTabularResultData();
            for (CliFunctionResult cliFunctionResult : funcResults) {
                tabularResult.accumulate("Member", (Object)cliFunctionResult.getMemberIdOrName());
                if (cliFunctionResult.isSuccessful()) {
                    tabularResult.accumulate("Status", (Object)"Successfully created lucene index");
                    continue;
                }
                tabularResult.accumulate("Status", (Object)("Failed: " + cliFunctionResult.getMessage()));
            }
            result = ResultBuilder.buildResult((ResultData)tabularResult);
        }
        catch (CommandResultException crex) {
            result = crex.getResult();
        }
        catch (Exception e) {
            result = ResultBuilder.createGemFireErrorResult((String)e.getMessage());
        }
        return result;
    }

    @CliCommand(value={"describe lucene index"}, help="Display the describe of lucene indexes created for all members.")
    @CliMetaData(shellOnly=false, relatedTopic={"Region", "Data"})
    @ResourceOperation(resource=GeodePermission.Resource.CLUSTER, operation=GeodePermission.Operation.READ)
    public Result describeIndex(@CliOption(key={"name"}, mandatory=true, help="Name of the lucene index to describe.") String indexName, @CliOption(key={"region"}, mandatory=true, optionContext="converter.hint.region.path", help="Name/Path of the region where the lucene index to be described exists.") String regionPath) {
        try {
            LuceneIndexInfo indexInfo = new LuceneIndexInfo(indexName, regionPath);
            return this.toTabularResult(this.getIndexDetails(indexInfo), true);
        }
        catch (FunctionInvocationTargetException ignore) {
            return ResultBuilder.createGemFireErrorResult((String)CliStrings.format((String)"Could not execute \" {0} \", please try again ", (Object)"describe lucene index"));
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            this.getCache().getLogger().error(t);
            return ResultBuilder.createGemFireErrorResult((String)String.format("An error occurred while collecting lucene index information across the Geode cluster: %1$s", LuceneIndexCommands.toString((Throwable)t, (boolean)this.isDebugging())));
        }
    }

    protected List<LuceneIndexDetails> getIndexDetails(LuceneIndexInfo indexInfo) throws Exception {
        GeodeSecurityUtil.authorizeRegionManage((String)indexInfo.getRegionPath());
        String[] groups = new String[]{};
        ResultCollector<?, ?> rc = this.executeFunctionOnGroups((FunctionAdapter)describeIndexFunction, groups, indexInfo);
        List funcResults = (List)rc.getResult();
        return funcResults.stream().filter(indexDetails -> indexDetails != null).collect(Collectors.toList());
    }

    @CliCommand(value={"lucene search"}, help="Search lucene index")
    @CliMetaData(shellOnly=false, relatedTopic={"Region", "Data"})
    @ResourceOperation(resource=GeodePermission.Resource.CLUSTER, operation=GeodePermission.Operation.READ)
    public Result searchIndex(@CliOption(key={"name"}, mandatory=true, help="Name of the lucene index to search.") String indexName, @CliOption(key={"region"}, mandatory=true, optionContext="converter.hint.region.path", help="Name/Path of the region where the lucene index exists.") String regionPath, @CliOption(key={"queryStrings"}, mandatory=true, help="Query string to search the lucene index") String queryString, @CliOption(key={"defaultField"}, mandatory=true, help="Default field to search in") String defaultField) {
        try {
            LuceneQueryInfo queryInfo = new LuceneQueryInfo(indexName, regionPath, queryString, defaultField);
            return this.getSearchResults(queryInfo);
        }
        catch (FunctionInvocationTargetException ignore) {
            return ResultBuilder.createGemFireErrorResult((String)CliStrings.format((String)"Could not execute \" {0} \", please try again ", (Object)"lucene search"));
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            this.getCache().getLogger().error(t);
            return ResultBuilder.createGemFireErrorResult((String)String.format("An error occurred while searching lucene index across the Geode cluster: %1$s", LuceneIndexCommands.toString((Throwable)t, (boolean)this.isDebugging())));
        }
    }

    private Result getSearchResults(LuceneQueryInfo queryInfo) throws Exception {
        GeodeSecurityUtil.authorizeRegionManage((String)queryInfo.getRegionPath());
        String[] groups = new String[]{};
        ResultCollector<?, ?> rc = this.executeFunctionOnGroups((FunctionAdapter)searchIndexFunction, groups, queryInfo);
        List functionResults = (List)rc.getResult();
        List results = functionResults.stream().flatMap(set -> set.stream()).sorted().collect(Collectors.toList());
        if (results.size() != 0) {
            TabularResultData data = ResultBuilder.createTabularResultData();
            for (LuceneSearchResults struct : results) {
                data.accumulate("key", (Object)struct.getKey());
                data.accumulate("value", (Object)struct.getValue());
                data.accumulate("score", (Object)Float.valueOf(struct.getScore()));
            }
            return ResultBuilder.buildResult((ResultData)data);
        }
        return ResultBuilder.createInfoResult((String)"No results");
    }

    protected ResultCollector<?, ?> executeFunctionOnGroups(FunctionAdapter function, String[] groups, LuceneIndexInfo indexInfo) throws CommandResultException {
        Set targetMembers = CliUtil.findAllMatchingMembers((String[])groups, null);
        return CliUtil.executeFunction((Function)function, (Object)indexInfo, (Set)targetMembers);
    }

    protected ResultCollector<?, ?> executeFunctionOnGroups(FunctionAdapter function, String[] groups, LuceneQueryInfo queryInfo) throws CommandResultException {
        Set targetMembers = CliUtil.findAllMatchingMembers((String[])groups, null);
        return CliUtil.executeFunction((Function)function, (Object)queryInfo, (Set)targetMembers);
    }
}

