/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.lucene.internal;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.lucene.LuceneIndex;
import com.gemstone.gemfire.cache.lucene.LuceneQueryException;
import com.gemstone.gemfire.cache.lucene.LuceneQueryProvider;
import com.gemstone.gemfire.cache.lucene.internal.LuceneIndexImpl;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.logging.LogService;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import org.apache.lucene.queryparser.flexible.standard.StandardQueryParser;
import org.apache.lucene.search.Query;

public class StringQueryProvider
implements LuceneQueryProvider,
DataSerializableFixedID {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LogService.getLogger();
    private String query;
    private transient Query luceneQuery;
    private String defaultField;

    public StringQueryProvider() {
        this(null, null);
    }

    public StringQueryProvider(String query, String defaultField) {
        this.query = query;
        this.defaultField = defaultField;
    }

    @Override
    public synchronized Query getQuery(LuceneIndex index) throws LuceneQueryException {
        if (this.luceneQuery == null) {
            String[] fields = index.getFieldNames();
            LuceneIndexImpl indexImpl = (LuceneIndexImpl)index;
            StandardQueryParser parser = new StandardQueryParser(indexImpl.getAnalyzer());
            try {
                this.luceneQuery = parser.parse(this.query, this.defaultField);
                if (logger.isDebugEnabled()) {
                    logger.debug("User query " + this.query + " is parsed to be: " + this.luceneQuery);
                }
            }
            catch (QueryNodeException e) {
                logger.debug("Query node exception:" + this.query, (Throwable)e);
                throw new LuceneQueryException("Malformed lucene query: " + this.query, e);
            }
        }
        return this.luceneQuery;
    }

    public String getQueryString() {
        return this.query;
    }

    public Version[] getSerializationVersions() {
        return null;
    }

    public int getDSFID() {
        return 2172;
    }

    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeString((String)this.query, (DataOutput)out);
        DataSerializer.writeString((String)this.defaultField, (DataOutput)out);
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.query = DataSerializer.readString((DataInput)in);
        this.defaultField = DataSerializer.readString((DataInput)in);
    }
}

