/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.lucene.internal;

import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.cache.lucene.internal.IndexRepositoryFactory;
import com.gemstone.gemfire.cache.lucene.internal.LuceneIndexStats;
import com.gemstone.gemfire.cache.lucene.internal.filesystem.FileSystemStats;
import com.gemstone.gemfire.cache.lucene.internal.repository.IndexRepository;
import com.gemstone.gemfire.cache.lucene.internal.repository.RepositoryManager;
import com.gemstone.gemfire.cache.lucene.internal.repository.serializer.LuceneSerializer;
import com.gemstone.gemfire.internal.cache.BucketNotFoundException;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.execute.InternalRegionFunctionContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.analysis.Analyzer;

public class PartitionedRepositoryManager
implements RepositoryManager {
    public static IndexRepositoryFactory indexRepositoryFactory = new IndexRepositoryFactory();
    private final ConcurrentHashMap<Integer, IndexRepository> indexRepositories = new ConcurrentHashMap();
    private final PartitionedRegion userRegion;
    private final PartitionedRegion fileRegion;
    private final PartitionedRegion chunkRegion;
    private final LuceneSerializer serializer;
    private final Analyzer analyzer;
    private final LuceneIndexStats indexStats;
    private final FileSystemStats fileSystemStats;

    public PartitionedRepositoryManager(PartitionedRegion userRegion, PartitionedRegion fileRegion, PartitionedRegion chunkRegion, LuceneSerializer serializer, Analyzer analyzer, LuceneIndexStats indexStats, FileSystemStats fileSystemStats) {
        this.userRegion = userRegion;
        this.fileRegion = fileRegion;
        this.chunkRegion = chunkRegion;
        this.serializer = serializer;
        this.analyzer = analyzer;
        this.indexStats = indexStats;
        this.fileSystemStats = fileSystemStats;
    }

    @Override
    public IndexRepository getRepository(Region region, Object key, Object callbackArg) throws BucketNotFoundException {
        BucketRegion userBucket = this.userRegion.getBucketRegion(key, callbackArg);
        if (userBucket == null) {
            throw new BucketNotFoundException("User bucket was not found for region " + region + "key " + key + " callbackarg " + callbackArg);
        }
        return this.getRepository(userBucket.getId());
    }

    @Override
    public Collection<IndexRepository> getRepositories(RegionFunctionContext ctx) throws BucketNotFoundException {
        Region region = ctx.getDataSet();
        Set buckets = ((InternalRegionFunctionContext)ctx).getLocalBucketSet(region);
        ArrayList<IndexRepository> repos = new ArrayList<IndexRepository>(buckets.size());
        for (Integer bucketId : buckets) {
            BucketRegion userBucket = this.userRegion.getDataStore().getLocalBucketById(bucketId);
            if (userBucket == null) {
                throw new BucketNotFoundException("User bucket was not found for region " + region + "bucket id " + bucketId);
            }
            repos.add(this.getRepository(userBucket.getId()));
        }
        return repos;
    }

    private IndexRepository getRepository(Integer bucketId) throws BucketNotFoundException {
        IndexRepository repo = this.indexRepositories.get(bucketId);
        if (repo != null && !repo.isClosed()) {
            return repo;
        }
        repo = this.indexRepositories.compute(bucketId, (key, oldRepository) -> {
            if (oldRepository != null && !oldRepository.isClosed()) {
                return oldRepository;
            }
            if (oldRepository != null) {
                oldRepository.cleanup();
            }
            try {
                return indexRepositoryFactory.createIndexRepository(bucketId, this.userRegion, this.fileRegion, this.chunkRegion, this.serializer, this.analyzer, this.indexStats, this.fileSystemStats);
            }
            catch (IOException e) {
                throw new InternalGemFireError("Unable to create index repository", (Throwable)e);
            }
        });
        if (repo == null) {
            throw new BucketNotFoundException("Colocated index buckets not found for regions " + this.chunkRegion + ", " + this.fileRegion + " bucket id " + bucketId);
        }
        return repo;
    }
}

