/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.lucene.internal;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.lucene.LuceneResultStruct;
import com.gemstone.gemfire.cache.lucene.PageableLuceneQueryResults;
import com.gemstone.gemfire.cache.lucene.internal.LuceneResultStructImpl;
import com.gemstone.gemfire.cache.lucene.internal.distributed.EntryScore;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class PageableLuceneQueryResultsImpl<K, V>
implements PageableLuceneQueryResults<K, V> {
    private final List<EntryScore<K>> hits;
    private List<LuceneResultStruct<K, V>> currentPage;
    private float maxScore = Float.MIN_VALUE;
    private final Region<K, V> userRegion;
    private int currentHit = 0;
    private int pageSize;

    public PageableLuceneQueryResultsImpl(List<EntryScore<K>> hits, Region<K, V> userRegion, int pageSize) {
        this.hits = hits;
        this.userRegion = userRegion;
        this.pageSize = pageSize == 0 ? Integer.MAX_VALUE : pageSize;
    }

    public List<LuceneResultStruct<K, V>> getHitEntries(int fromIndex, int toIndex) {
        List<EntryScore<K>> scores = this.hits.subList(fromIndex, toIndex);
        ArrayList<K> keys = new ArrayList<K>(scores.size());
        for (EntryScore<K> score : scores) {
            keys.add(score.getKey());
        }
        Map values = this.userRegion.getAll(keys);
        ArrayList<LuceneResultStruct<K, V>> results = new ArrayList<LuceneResultStruct<K, V>>(scores.size());
        for (EntryScore<K> score : scores) {
            Object value = values.get(score.getKey());
            if (value == null) continue;
            results.add(new LuceneResultStructImpl(score.getKey(), value, score.getScore()));
        }
        return results;
    }

    @Override
    public List<LuceneResultStruct<K, V>> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        List<LuceneResultStruct<K, V>> result = this.advancePage();
        this.currentPage = null;
        return result;
    }

    private List<LuceneResultStruct<K, V>> advancePage() {
        if (this.currentPage != null) {
            return this.currentPage;
        }
        int resultSize = this.pageSize != Integer.MAX_VALUE ? this.pageSize : this.hits.size();
        this.currentPage = new ArrayList<LuceneResultStruct<K, V>>(resultSize);
        while (this.currentPage.size() < this.pageSize && this.currentHit < this.hits.size()) {
            int end = this.currentHit + this.pageSize - this.currentPage.size();
            end = end > this.hits.size() ? this.hits.size() : end;
            this.currentPage.addAll(this.getHitEntries(this.currentHit, end));
            this.currentHit = end;
        }
        return this.currentPage;
    }

    @Override
    public boolean hasNext() {
        this.advancePage();
        return !this.currentPage.isEmpty();
    }

    @Override
    public int size() {
        return this.hits.size();
    }

    @Override
    public float getMaxScore() {
        if (this.maxScore == Float.MIN_VALUE) {
            for (EntryScore<K> score : this.hits) {
                this.maxScore = Math.max(this.maxScore, score.getScore());
            }
        }
        return this.maxScore;
    }
}

