/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.lucene.internal;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.cache.lucene.LuceneQuery;
import com.gemstone.gemfire.cache.lucene.LuceneQueryException;
import com.gemstone.gemfire.cache.lucene.LuceneQueryProvider;
import com.gemstone.gemfire.cache.lucene.LuceneResultStruct;
import com.gemstone.gemfire.cache.lucene.PageableLuceneQueryResults;
import com.gemstone.gemfire.cache.lucene.internal.PageableLuceneQueryResultsImpl;
import com.gemstone.gemfire.cache.lucene.internal.distributed.EntryScore;
import com.gemstone.gemfire.cache.lucene.internal.distributed.LuceneFunction;
import com.gemstone.gemfire.cache.lucene.internal.distributed.LuceneFunctionContext;
import com.gemstone.gemfire.cache.lucene.internal.distributed.TopEntries;
import com.gemstone.gemfire.cache.lucene.internal.distributed.TopEntriesCollector;
import com.gemstone.gemfire.cache.lucene.internal.distributed.TopEntriesCollectorManager;
import com.gemstone.gemfire.cache.lucene.internal.distributed.TopEntriesFunctionCollector;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class LuceneQueryImpl<K, V>
implements LuceneQuery<K, V> {
    private int limit = 100;
    private int pageSize = 0;
    private String indexName;
    private String[] projectedFieldNames;
    private LuceneQueryProvider query;
    private Region<K, V> region;
    private String defaultField;

    public LuceneQueryImpl(String indexName, Region<K, V> region, LuceneQueryProvider provider, String[] projectionFields, int limit, int pageSize) {
        this.indexName = indexName;
        this.region = region;
        this.limit = limit;
        this.pageSize = pageSize;
        this.projectedFieldNames = projectionFields;
        this.query = provider;
    }

    @Override
    public Collection<K> findKeys() throws LuceneQueryException {
        TopEntries<K> entries = this.findTopEntries();
        List<EntryScore<K>> hits = entries.getHits();
        return hits.stream().map(hit -> hit.getKey()).collect(Collectors.toList());
    }

    @Override
    public Collection<V> findValues() throws LuceneQueryException {
        List<LuceneResultStruct<K, V>> page = this.findResults();
        return page.stream().map(entry -> entry.getValue()).collect(Collectors.toList());
    }

    @Override
    public List<LuceneResultStruct<K, V>> findResults() throws LuceneQueryException {
        PageableLuceneQueryResults<K, V> pages = this.findPages(0);
        if (!pages.hasNext()) {
            return Collections.emptyList();
        }
        return pages.next();
    }

    @Override
    public PageableLuceneQueryResults<K, V> findPages() throws LuceneQueryException {
        return this.findPages(this.pageSize);
    }

    private PageableLuceneQueryResults<K, V> findPages(int pageSize) throws LuceneQueryException {
        TopEntries<K> entries = this.findTopEntries();
        return new PageableLuceneQueryResultsImpl<K, V>(entries.getHits(), this.region, pageSize);
    }

    private TopEntries<K> findTopEntries() throws LuceneQueryException {
        TopEntries entries;
        TopEntriesCollectorManager manager = new TopEntriesCollectorManager(null, this.limit);
        LuceneFunctionContext<TopEntriesCollector> context = new LuceneFunctionContext<TopEntriesCollector>(this.query, this.indexName, manager, this.limit);
        TopEntriesFunctionCollector collector = new TopEntriesFunctionCollector(context);
        ResultCollector rc = this.onRegion().withArgs(context).withCollector((ResultCollector)collector).execute(LuceneFunction.ID);
        try {
            entries = (TopEntries)rc.getResult();
        }
        catch (FunctionException e) {
            if (e.getCause() instanceof LuceneQueryException) {
                throw new LuceneQueryException(e);
            }
            throw e;
        }
        return entries;
    }

    protected Execution onRegion() {
        return FunctionService.onRegion(this.region);
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public String[] getProjectedFieldNames() {
        return this.projectedFieldNames;
    }
}

