/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.lucene.internal;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsFactory;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.StatisticsTypeFactory;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.internal.CopyOnWriteHashSet;
import com.gemstone.gemfire.internal.StatisticsTypeFactoryImpl;
import java.util.function.IntSupplier;

public class LuceneIndexStats {
    private static final StatisticsType statsType;
    private static final String statsTypeName = "LuceneIndexStats";
    private static final String statsTypeDescription = "Statistics about lucene indexes";
    private static final int queryExecutionsId;
    private static final int queryExecutionTimeId;
    private static final int queryExecutionsInProgressId;
    private static final int queryExecutionTotalHits;
    private static final int updatesId;
    private static final int updateTimeId;
    private static final int updatesInProgressId;
    private static final int commitsId;
    private static final int commitTimeId;
    private static final int commitsInProgressId;
    private static final int documentsId;
    private final Statistics stats;
    private final CopyOnWriteHashSet<IntSupplier> documentsSuppliers = new CopyOnWriteHashSet();

    public LuceneIndexStats(StatisticsFactory f, String name) {
        this.stats = f.createAtomicStatistics(statsType, name);
        this.stats.setIntSupplier(documentsId, this::computeDocumentCount);
    }

    public long startQuery() {
        this.stats.incInt(queryExecutionsInProgressId, 1);
        return DistributionStats.getStatTime();
    }

    public void endQuery(long start, int totalHits) {
        this.stats.incLong(queryExecutionTimeId, DistributionStats.getStatTime() - start);
        this.stats.incInt(queryExecutionsInProgressId, -1);
        this.stats.incInt(queryExecutionsId, 1);
        this.stats.incLong(queryExecutionTotalHits, (long)totalHits);
    }

    public long startUpdate() {
        this.stats.incInt(updatesInProgressId, 1);
        return DistributionStats.getStatTime();
    }

    public void endUpdate(long start) {
        this.stats.incLong(updateTimeId, DistributionStats.getStatTime() - start);
        this.stats.incInt(updatesInProgressId, -1);
        this.stats.incInt(updatesId, 1);
    }

    public long startCommit() {
        this.stats.incInt(commitsInProgressId, 1);
        return DistributionStats.getStatTime();
    }

    public void endCommit(long start) {
        this.stats.incLong(commitTimeId, DistributionStats.getStatTime() - start);
        this.stats.incInt(commitsInProgressId, -1);
        this.stats.incInt(commitsId, 1);
    }

    public void addDocumentsSupplier(IntSupplier supplier) {
        this.documentsSuppliers.add((Object)supplier);
    }

    public void removeDocumentsSupplier(IntSupplier supplier) {
        this.documentsSuppliers.remove((Object)supplier);
    }

    public int getDocuments() {
        return this.stats.getInt(documentsId);
    }

    private int computeDocumentCount() {
        return this.documentsSuppliers.stream().mapToInt(IntSupplier::getAsInt).sum();
    }

    public int getQueryExecutions() {
        return this.stats.getInt(queryExecutionsId);
    }

    public long getQueryExecutionTime() {
        return this.stats.getLong(queryExecutionTimeId);
    }

    public int getQueryExecutionsInProgress() {
        return this.stats.getInt(queryExecutionsInProgressId);
    }

    public long getQueryExecutionTotalHits() {
        return this.stats.getLong(queryExecutionTotalHits);
    }

    public int getUpdates() {
        return this.stats.getInt(updatesId);
    }

    public long getUpdateTime() {
        return this.stats.getLong(updateTimeId);
    }

    public int getUpdatesInProgress() {
        return this.stats.getInt(updatesInProgressId);
    }

    public int getCommits() {
        return this.stats.getInt(commitsId);
    }

    public long getCommitTime() {
        return this.stats.getLong(commitTimeId);
    }

    public int getCommitsInProgress() {
        return this.stats.getInt(commitsInProgressId);
    }

    static {
        StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
        statsType = f.createType(statsTypeName, statsTypeDescription, new StatisticDescriptor[]{f.createIntCounter("queryExecutions", "Number of lucene queries executed on this member", "operations"), f.createLongCounter("queryExecutionTime", "Amount of time spent executing lucene queries", "nanoseconds"), f.createIntGauge("queryExecutionsInProgress", "Number of query executions currently in progress", "operations"), f.createLongCounter("queryExecutionTotalHits", "Total number of documents returned by query executions", "entries"), f.createIntCounter("updates", "Number of lucene index documents added/removed on this member", "operations"), f.createLongCounter("updateTime", "Amount of time spent adding or removing documents from the index", "nanoseconds"), f.createIntGauge("updatesInProgress", "Number of index updates in progress", "operations"), f.createIntCounter("commits", "Number of lucene index commits on this member", "operations"), f.createLongCounter("commitTime", "Amount of time spent in lucene index commits", "nanoseconds"), f.createIntGauge("commitsInProgress", "Number of lucene index commits in progress", "operations"), f.createIntGauge("documents", "Number of documents in the index", "documents")});
        queryExecutionsId = statsType.nameToId("queryExecutions");
        queryExecutionTimeId = statsType.nameToId("queryExecutionTime");
        queryExecutionsInProgressId = statsType.nameToId("queryExecutionsInProgress");
        queryExecutionTotalHits = statsType.nameToId("queryExecutionTotalHits");
        updatesId = statsType.nameToId("updates");
        updateTimeId = statsType.nameToId("updateTime");
        updatesInProgressId = statsType.nameToId("updatesInProgress");
        commitsId = statsType.nameToId("commits");
        commitTimeId = statsType.nameToId("commitTime");
        commitsInProgressId = statsType.nameToId("commitsInProgress");
        documentsId = statsType.nameToId("documents");
    }
}

