/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.lucene.internal;

import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.StatisticsFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueue;
import com.gemstone.gemfire.cache.lucene.internal.InternalLuceneIndex;
import com.gemstone.gemfire.cache.lucene.internal.LuceneIndexStats;
import com.gemstone.gemfire.cache.lucene.internal.LuceneServiceImpl;
import com.gemstone.gemfire.cache.lucene.internal.filesystem.ChunkKey;
import com.gemstone.gemfire.cache.lucene.internal.filesystem.File;
import com.gemstone.gemfire.cache.lucene.internal.filesystem.FileSystemStats;
import com.gemstone.gemfire.cache.lucene.internal.repository.RepositoryManager;
import com.gemstone.gemfire.cache.lucene.internal.xml.LuceneIndexCreation;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InternalRegionArguments;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.extension.Extension;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;

public abstract class LuceneIndexImpl
implements InternalLuceneIndex {
    protected static final Logger logger = LogService.getLogger();
    protected final String indexName;
    protected final String regionPath;
    protected final Cache cache;
    protected final LuceneIndexStats indexStats;
    protected final FileSystemStats fileSystemStats;
    protected boolean hasInitialized = false;
    protected Map<String, Analyzer> fieldAnalyzers;
    protected String[] searchableFieldNames;
    protected RepositoryManager repositoryManager;
    protected Analyzer analyzer;
    protected Region<String, File> fileRegion;
    protected Region<ChunkKey, byte[]> chunkRegion;

    protected LuceneIndexImpl(String indexName, String regionPath, Cache cache) {
        this.indexName = indexName;
        this.regionPath = regionPath;
        this.cache = cache;
        String statsName = indexName + "-" + regionPath;
        this.indexStats = new LuceneIndexStats((StatisticsFactory)cache.getDistributedSystem(), statsName);
        this.fileSystemStats = new FileSystemStats((StatisticsFactory)cache.getDistributedSystem(), statsName);
    }

    @Override
    public String getName() {
        return this.indexName;
    }

    @Override
    public String getRegionPath() {
        return this.regionPath;
    }

    protected void setSearchableFields(String[] fields) {
        this.searchableFieldNames = fields;
    }

    @Override
    public boolean waitUntilFlushed(int maxWaitInMillisecond) {
        String aeqId = LuceneServiceImpl.getUniqueIndexName(this.indexName, this.regionPath);
        AsyncEventQueue queue = this.cache.getAsyncEventQueue(aeqId);
        boolean flushed = false;
        if (queue != null) {
            long start = System.nanoTime();
            while (System.nanoTime() - start < TimeUnit.MILLISECONDS.toNanos(maxWaitInMillisecond)) {
                if (0 == queue.size()) {
                    flushed = true;
                    break;
                }
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
            }
        } else {
            throw new IllegalArgumentException("The AEQ does not exist for the index " + this.indexName + " region " + this.regionPath);
        }
        return flushed;
    }

    @Override
    public String[] getFieldNames() {
        return this.searchableFieldNames;
    }

    @Override
    public Map<String, Analyzer> getFieldAnalyzers() {
        return this.fieldAnalyzers;
    }

    @Override
    public RepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer == null ? new StandardAnalyzer() : analyzer;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public void setFieldAnalyzers(Map<String, Analyzer> fieldAnalyzers) {
        this.fieldAnalyzers = fieldAnalyzers == null ? null : Collections.unmodifiableMap(fieldAnalyzers);
    }

    public LuceneIndexStats getIndexStats() {
        return this.indexStats;
    }

    public FileSystemStats getFileSystemStats() {
        return this.fileSystemStats;
    }

    protected abstract void initialize();

    protected void addExtension(PartitionedRegion dataRegion) {
        LuceneIndexCreation creation = new LuceneIndexCreation();
        creation.setName(this.getName());
        creation.addFieldNames(this.getFieldNames());
        creation.setRegion((Region)dataRegion);
        creation.setFieldAnalyzers(this.getFieldAnalyzers());
        dataRegion.getExtensionPoint().addExtension((Extension)creation);
    }

    protected <K, V> Region<K, V> createRegion(String regionName, RegionAttributes<K, V> attributes) {
        InternalRegionArguments ira = new InternalRegionArguments().setDestroyLockFlag(true).setRecreateFlag(false).setSnapshotInputStream(null).setImageTarget(null).setIsUsedForMetaRegion(true);
        try {
            return ((GemFireCacheImpl)this.cache).createVMRegion(regionName, attributes, ira);
        }
        catch (Exception e) {
            InternalGemFireError ige = new InternalGemFireError(LocalizedStrings.GemFireCache_UNEXPECTED_EXCEPTION.toLocalizedString());
            ige.initCause((Throwable)e);
            throw ige;
        }
    }
}

