/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.lucene.internal;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventListener;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueue;
import com.gemstone.gemfire.cache.asyncqueue.internal.AsyncEventQueueFactoryImpl;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.cache.lucene.internal.LuceneEventListener;
import com.gemstone.gemfire.cache.lucene.internal.LuceneIndexImpl;
import com.gemstone.gemfire.cache.lucene.internal.LuceneServiceImpl;
import com.gemstone.gemfire.cache.lucene.internal.PartitionedRepositoryManager;
import com.gemstone.gemfire.cache.lucene.internal.directory.DumpDirectoryFiles;
import com.gemstone.gemfire.cache.lucene.internal.filesystem.ChunkKey;
import com.gemstone.gemfire.cache.lucene.internal.repository.serializer.HeterogeneousLuceneSerializer;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;

public class LuceneIndexForPartitionedRegion
extends LuceneIndexImpl {
    public LuceneIndexForPartitionedRegion(String indexName, String regionPath, Cache cache) {
        super(indexName, regionPath, cache);
    }

    @Override
    public void initialize() {
        if (!this.hasInitialized) {
            String chunkRegionName;
            PartitionedRegion dataRegion = this.getDataRegion();
            RegionAttributes regionAttributes = dataRegion.getAttributes();
            DataPolicy dp = regionAttributes.getDataPolicy();
            boolean withPersistence = dp.withPersistence();
            boolean withStorage = regionAttributes.getPartitionAttributes().getLocalMaxMemory() > 0;
            RegionShortcut regionShortCut = withPersistence ? RegionShortcut.PARTITION_PERSISTENT : RegionShortcut.PARTITION;
            if (!withStorage) {
                throw new IllegalStateException("The data region to create lucene index should be with storage");
            }
            String fileRegionName = this.createFileRegionName();
            PartitionAttributes partitionAttributes = dataRegion.getPartitionAttributes();
            if (!this.fileRegionExists(fileRegionName)) {
                this.fileRegion = this.createFileRegion(regionShortCut, fileRegionName, partitionAttributes, regionAttributes);
            }
            if (!this.chunkRegionExists(chunkRegionName = this.createChunkRegionName())) {
                this.chunkRegion = this.createChunkRegion(regionShortCut, fileRegionName, partitionAttributes, chunkRegionName, regionAttributes);
            }
            this.fileSystemStats.setFileSupplier(() -> (int)this.getFileRegion().getLocalSize());
            this.fileSystemStats.setChunkSupplier(() -> (int)this.getChunkRegion().getLocalSize());
            this.fileSystemStats.setBytesSupplier(() -> this.getChunkRegion().getPrStats().getDataStoreBytesInUse());
            HeterogeneousLuceneSerializer mapper = new HeterogeneousLuceneSerializer(this.getFieldNames());
            this.repositoryManager = new PartitionedRepositoryManager(dataRegion, (PartitionedRegion)this.fileRegion, (PartitionedRegion)this.chunkRegion, mapper, this.analyzer, this.indexStats, this.fileSystemStats);
            this.createAEQ((Region)dataRegion);
            this.addExtension(dataRegion);
            this.hasInitialized = true;
        }
    }

    private PartitionedRegion getDataRegion() {
        return (PartitionedRegion)this.cache.getRegion(this.regionPath);
    }

    private PartitionedRegion getFileRegion() {
        return (PartitionedRegion)this.fileRegion;
    }

    private PartitionedRegion getChunkRegion() {
        return (PartitionedRegion)this.chunkRegion;
    }

    private AsyncEventQueueFactoryImpl createAEQFactory(Region dataRegion) {
        AsyncEventQueueFactoryImpl factory = (AsyncEventQueueFactoryImpl)this.cache.createAsyncEventQueueFactory();
        factory.setParallel(true);
        factory.setMaximumQueueMemory(1000);
        factory.setDispatcherThreads(1);
        factory.setIsMetaQueue(true);
        if (dataRegion.getAttributes().getDataPolicy().withPersistence()) {
            factory.setPersistent(true);
        }
        factory.setDiskStoreName(dataRegion.getAttributes().getDiskStoreName());
        factory.setDiskSynchronous(dataRegion.getAttributes().isDiskSynchronous());
        factory.setForwardExpirationDestroy(true);
        return factory;
    }

    AsyncEventQueue createAEQ(Region dataRegion) {
        return this.createAEQ(this.createAEQFactory(dataRegion));
    }

    private AsyncEventQueue createAEQ(AsyncEventQueueFactoryImpl factory) {
        LuceneEventListener listener = new LuceneEventListener(this.repositoryManager);
        String aeqId = LuceneServiceImpl.getUniqueIndexName(this.getName(), this.regionPath);
        AsyncEventQueue indexQueue = factory.create(aeqId, (AsyncEventListener)listener);
        return indexQueue;
    }

    boolean fileRegionExists(String fileRegionName) {
        return this.cache.getRegion(fileRegionName) != null;
    }

    Region createFileRegion(RegionShortcut regionShortCut, String fileRegionName, PartitionAttributes partitionAttributes, RegionAttributes regionAttributes) {
        return this.createRegion(fileRegionName, regionShortCut, this.regionPath, partitionAttributes, regionAttributes);
    }

    public String createFileRegionName() {
        return LuceneServiceImpl.getUniqueIndexName(this.indexName, this.regionPath) + ".files";
    }

    boolean chunkRegionExists(String chunkRegionName) {
        return this.cache.getRegion(chunkRegionName) != null;
    }

    Region<ChunkKey, byte[]> createChunkRegion(RegionShortcut regionShortCut, String fileRegionName, PartitionAttributes partitionAttributes, String chunkRegionName, RegionAttributes regionAttributes) {
        return this.createRegion(chunkRegionName, regionShortCut, fileRegionName, partitionAttributes, regionAttributes);
    }

    public String createChunkRegionName() {
        return LuceneServiceImpl.getUniqueIndexName(this.indexName, this.regionPath) + ".chunks";
    }

    private PartitionAttributesFactory configureLuceneRegionAttributesFactory(PartitionAttributesFactory attributesFactory, PartitionAttributes<?, ?> dataRegionAttributes) {
        attributesFactory.setTotalNumBuckets(dataRegionAttributes.getTotalNumBuckets());
        attributesFactory.setRedundantCopies(dataRegionAttributes.getRedundantCopies());
        return attributesFactory;
    }

    protected <K, V> Region<K, V> createRegion(String regionName, RegionShortcut regionShortCut, String colocatedWithRegionName, PartitionAttributes partitionAttributes, RegionAttributes regionAttributes) {
        PartitionAttributesFactory partitionAttributesFactory = new PartitionAttributesFactory();
        partitionAttributesFactory.setColocatedWith(colocatedWithRegionName);
        this.configureLuceneRegionAttributesFactory(partitionAttributesFactory, partitionAttributes);
        RegionAttributes baseAttributes = this.cache.getRegionAttributes(regionShortCut.toString());
        AttributesFactory factory = new AttributesFactory(baseAttributes);
        factory.setPartitionAttributes(partitionAttributesFactory.create());
        factory.setDiskStoreName(regionAttributes.getDiskStoreName());
        RegionAttributes attributes = factory.create();
        return this.createRegion(regionName, attributes);
    }

    public void close() {
    }

    @Override
    public void dumpFiles(String directory) {
        ResultCollector results = FunctionService.onRegion((Region)this.getDataRegion()).withArgs((Object)new String[]{directory, this.indexName}).execute(DumpDirectoryFiles.ID);
        results.getResult();
    }
}

