/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.lucene.internal;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.cache.CacheServiceProfile;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;

public class LuceneIndexCreationProfile
implements CacheServiceProfile,
DataSerializable {
    private String indexName;
    private String[] fieldNames;
    private Class<? extends Analyzer> analyzerClass;
    private Map<String, Class<? extends Analyzer>> fieldAnalyzers;

    public LuceneIndexCreationProfile() {
    }

    public LuceneIndexCreationProfile(String indexName, String[] fieldNames, Analyzer analyzer, Map<String, Analyzer> fieldAnalyzers) {
        this.indexName = indexName;
        this.fieldNames = fieldNames;
        this.analyzerClass = analyzer.getClass();
        this.initializeFieldAnalyzers(fieldAnalyzers);
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String[] getFieldNames() {
        return this.fieldNames;
    }

    public Class<? extends Analyzer> getAnalyzerClass() {
        return this.analyzerClass;
    }

    public Map<String, Class<? extends Analyzer>> getFieldAnalyzers() {
        return this.fieldAnalyzers;
    }

    protected void initializeFieldAnalyzers(Map<String, Analyzer> fieldAnalyzers) {
        if (fieldAnalyzers != null && !fieldAnalyzers.isEmpty()) {
            this.fieldAnalyzers = new HashMap<String, Class<? extends Analyzer>>();
            for (Map.Entry<String, Analyzer> entry : fieldAnalyzers.entrySet()) {
                this.fieldAnalyzers.put(entry.getKey(), entry.getValue() == null ? null : entry.getValue().getClass());
            }
        }
    }

    public String getId() {
        return this.indexName;
    }

    public String checkCompatibility(String regionPath, CacheServiceProfile profile) {
        String result = null;
        LuceneIndexCreationProfile myProfile = (LuceneIndexCreationProfile)profile;
        if (myProfile != null) {
            if (!Arrays.equals(myProfile.getFieldNames(), this.getFieldNames())) {
                result = LocalizedStrings.LuceneService_CANNOT_CREATE_INDEX_0_ON_REGION_1_WITH_FIELDS_2_BECAUSE_ANOTHER_MEMBER_DEFINES_THE_SAME_INDEX_WITH_FIELDS_3.toString(new Object[]{myProfile.getIndexName(), regionPath, Arrays.toString(this.getFieldNames()), Arrays.toString(myProfile.getFieldNames())});
            }
            if (myProfile.getFieldAnalyzers() != null || this.getFieldAnalyzers() != null) {
                if (myProfile.getFieldAnalyzers() == null) {
                    result = LocalizedStrings.LuceneService_CANNOT_CREATE_INDEX_0_ON_REGION_1_WITH_FIELD_ANALYZERS_2_BECAUSE_ANOTHER_MEMBER_DEFINES_THE_SAME_INDEX_WITH_NO_FIELD_ANALYZERS.toString(new Object[]{myProfile.getIndexName(), regionPath, this.getFieldAnalyzers()});
                } else if (this.getFieldAnalyzers() == null) {
                    result = LocalizedStrings.LuceneService_CANNOT_CREATE_INDEX_0_ON_REGION_1_WITH_NO_FIELD_ANALYZERS_BECAUSE_ANOTHER_MEMBER_DEFINES_THE_SAME_INDEX_WITH_FIELD_ANALYZERS_2.toString(new Object[]{myProfile.getIndexName(), regionPath, myProfile.getFieldAnalyzers()});
                } else {
                    if (myProfile.getFieldAnalyzers().size() != this.getFieldAnalyzers().size()) {
                        result = LocalizedStrings.LuceneService_CANNOT_CREATE_INDEX_0_ON_REGION_1_WITH_FIELD_ANALYZERS_2_BECAUSE_ANOTHER_MEMBER_DEFINES_THE_SAME_INDEX_WITH_FIELD_ANALYZERS_3.toString(new Object[]{myProfile.getIndexName(), regionPath, this.getFieldAnalyzers(), myProfile.getFieldAnalyzers()});
                    }
                    for (Map.Entry<String, Class<? extends Analyzer>> entry : myProfile.getFieldAnalyzers().entrySet()) {
                        Class<? extends Analyzer> analyzerClass = this.getFieldAnalyzers().remove(entry.getKey());
                        if (analyzerClass == null && entry.getValue() != null) {
                            result = LocalizedStrings.LuceneService_CANNOT_CREATE_INDEX_0_ON_REGION_1_WITH_NO_ANALYZER_ON_FIELD_2_BECAUSE_ANOTHER_MEMBER_DEFINES_THE_SAME_INDEX_WITH_ANALYZER_3_ON_THAT_FIELD.toString(new Object[]{myProfile.getIndexName(), regionPath, entry.getKey(), entry.getValue().getName()});
                            break;
                        }
                        if (analyzerClass != null && entry.getValue() == null) {
                            result = LocalizedStrings.LuceneService_CANNOT_CREATE_INDEX_0_ON_REGION_1_WITH_ANALYZER_2_ON_FIELD_3_BECAUSE_ANOTHER_MEMBER_DEFINES_THE_SAME_INDEX_WITH_NO_ANALYZER_ON_THAT_FIELD.toString(new Object[]{myProfile.getIndexName(), regionPath, analyzerClass.getName(), entry.getKey()});
                            break;
                        }
                        if (analyzerClass == entry.getValue()) continue;
                        result = LocalizedStrings.LuceneService_CANNOT_CREATE_INDEX_0_ON_REGION_1_WITH_ANALYZER_2_ON_FIELD_3_BECAUSE_ANOTHER_MEMBER_DEFINES_THE_SAME_INDEX_WITH_ANALYZER_4_ON_THAT_FIELD.toString(new Object[]{myProfile.getIndexName(), regionPath, analyzerClass.getName(), entry.getKey(), entry.getValue().getName()});
                        break;
                    }
                }
            }
        }
        return result;
    }

    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeString((String)this.indexName, (DataOutput)out);
        DataSerializer.writeStringArray((String[])this.fieldNames, (DataOutput)out);
        DataSerializer.writeClass(this.analyzerClass, (DataOutput)out);
        DataSerializer.writeHashMap(this.fieldAnalyzers, (DataOutput)out);
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.indexName = DataSerializer.readString((DataInput)in);
        this.fieldNames = DataSerializer.readStringArray((DataInput)in);
        this.analyzerClass = DataSerializer.readClass((DataInput)in);
        this.fieldAnalyzers = DataSerializer.readHashMap((DataInput)in);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "indexName=" + this.indexName + "; fieldNames=" + Arrays.toString(this.fieldNames) + "; analyzerClass=" + this.analyzerClass + "; fieldAnalyzers=" + this.fieldAnalyzers + "]";
    }
}

