/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.lucene.internal;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.lucene.internal.LuceneIndexStats;
import com.gemstone.gemfire.cache.lucene.internal.directory.RegionDirectory;
import com.gemstone.gemfire.cache.lucene.internal.filesystem.ChunkKey;
import com.gemstone.gemfire.cache.lucene.internal.filesystem.File;
import com.gemstone.gemfire.cache.lucene.internal.filesystem.FileSystemStats;
import com.gemstone.gemfire.cache.lucene.internal.repository.IndexRepository;
import com.gemstone.gemfire.cache.lucene.internal.repository.IndexRepositoryImpl;
import com.gemstone.gemfire.cache.lucene.internal.repository.serializer.LuceneSerializer;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import java.io.IOException;
import java.util.concurrent.ConcurrentMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;

public class IndexRepositoryFactory {
    public IndexRepository createIndexRepository(Integer bucketId, PartitionedRegion userRegion, PartitionedRegion fileRegion, PartitionedRegion chunkRegion, LuceneSerializer serializer, Analyzer analyzer, LuceneIndexStats indexStats, FileSystemStats fileSystemStats) throws IOException {
        BucketRegion fileBucket = this.getMatchingBucket(fileRegion, bucketId);
        BucketRegion chunkBucket = this.getMatchingBucket(chunkRegion, bucketId);
        if (fileBucket == null || chunkBucket == null) {
            return null;
        }
        RegionDirectory dir = new RegionDirectory((ConcurrentMap<String, File>)fileBucket, (ConcurrentMap<ChunkKey, byte[]>)chunkBucket, fileSystemStats);
        IndexWriterConfig config = new IndexWriterConfig(analyzer);
        IndexWriter writer = new IndexWriter((Directory)dir, config);
        IndexRepositoryImpl repo = new IndexRepositoryImpl((Region<?, ?>)fileBucket, writer, serializer, indexStats);
        return repo;
    }

    protected BucketRegion getMatchingBucket(PartitionedRegion region, Integer bucketId) {
        region.getOrCreateNodeForBucketWrite(bucketId.intValue(), null);
        return region.getDataStore().getLocalBucketById(bucketId);
    }
}

