/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.logging.internal.executors;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.geode.logging.internal.executors.LoggingThread;
import org.apache.geode.logging.internal.executors.LoggingThreadFactory;
import org.apache.geode.logging.internal.executors.LoggingUncaughtExceptionHandler;

public class LoggingExecutors {
    public static ScheduledExecutorService newScheduledThreadPool(String threadName, int poolSize, boolean executeDelayedTasks) {
        ScheduledThreadPoolExecutor result = new ScheduledThreadPoolExecutor(poolSize, new LoggingThreadFactory(threadName));
        result.setExecuteExistingDelayedTasksAfterShutdownPolicy(executeDelayedTasks);
        return result;
    }

    public static ExecutorService newFixedThreadPoolWithFeedSize(String threadName, int poolSize, int feedSize) {
        LinkedBlockingQueue<Runnable> feed = new LinkedBlockingQueue<Runnable>(feedSize);
        ThreadPoolExecutor.CallerRunsPolicy rejectionHandler = new ThreadPoolExecutor.CallerRunsPolicy();
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(threadName);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(poolSize, poolSize, 10L, TimeUnit.SECONDS, feed, threadFactory, rejectionHandler);
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    public static ExecutorService newSingleThreadExecutor(String threadName, boolean isDaemon) {
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(threadName, isDaemon);
        return new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
    }

    public static ExecutorService newCachedThreadPool(String threadName, boolean isDaemon) {
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(threadName, isDaemon);
        return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
    }

    public static ExecutorService newWorkStealingPool(String threadName, int maxParallelThreads) {
        ForkJoinPool.ForkJoinWorkerThreadFactory factory = pool -> {
            ForkJoinWorkerThread worker = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
            LoggingUncaughtExceptionHandler.setOnThread(worker);
            worker.setName(threadName + worker.getPoolIndex());
            return worker;
        };
        return new ForkJoinPool(maxParallelThreads, factory, null, true);
    }

    public static Executor newThreadOnEachExecute(String threadName) {
        return command -> new LoggingThread(threadName, command).start();
    }

    public static ScheduledExecutorService newScheduledThreadPool(String threadName, int poolSize) {
        return LoggingExecutors.newScheduledThreadPool(threadName, poolSize, true);
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(String threadName) {
        return LoggingExecutors.newScheduledThreadPool(threadName, 1);
    }

    public static ThreadPoolExecutor newFixedThreadPool(String threadName, boolean isDaemon, int poolSize, long keepAliveSeconds, BlockingQueue<Runnable> feed) {
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(threadName, isDaemon);
        return new ThreadPoolExecutor(poolSize, poolSize, keepAliveSeconds, TimeUnit.SECONDS, feed, threadFactory);
    }

    private static ThreadPoolExecutor newFixedThreadPool(String threadName, boolean isDaemon, long keepAliveSeconds, int poolSize) {
        LinkedBlockingQueue<Runnable> feed = new LinkedBlockingQueue<Runnable>();
        return LoggingExecutors.newFixedThreadPool(threadName, isDaemon, poolSize, keepAliveSeconds, feed);
    }

    public static ExecutorService newFixedThreadPool(String threadName, boolean isDaemon, int poolSize) {
        return LoggingExecutors.newFixedThreadPool(threadName, isDaemon, 0L, poolSize);
    }

    public static ExecutorService newFixedThreadPoolWithTimeout(String threadName, int poolSize, int keepAliveSeconds) {
        return LoggingExecutors.newFixedThreadPool(threadName, true, keepAliveSeconds, poolSize);
    }
}

