/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.alerting.log4j.internal.impl;

import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.geode.alerting.internal.AlertingSessionRegistryProvider;
import org.apache.geode.alerting.internal.NullAlertingService;
import org.apache.geode.alerting.internal.api.AlertingService;
import org.apache.geode.alerting.internal.log4j.AlertLevelConverter;
import org.apache.geode.alerting.internal.spi.AlertLevel;
import org.apache.geode.alerting.internal.spi.AlertingAction;
import org.apache.geode.alerting.internal.spi.AlertingSessionListener;
import org.apache.geode.alerting.internal.spi.AlertingSessionRegistry;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.logging.log4j.internal.impl.DebuggableAppender;
import org.apache.geode.logging.log4j.internal.impl.PausableAppender;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;

@Plugin(name="GeodeAlert", category="Core", elementType="appender", printObject=true)
public class AlertAppender
extends AbstractAppender
implements PausableAppender,
DebuggableAppender,
AlertingSessionListener {
    static final String PLUGIN_NAME = "GeodeAlert";
    private static final boolean START_PAUSED_BY_DEFAULT = true;
    private final AtomicReference<AlertingService> alertingServiceRef = new AtomicReference<NullAlertingService>(NullAlertingService.get());
    private final boolean debug;
    private final List<LogEvent> events;
    private final AlertingSessionRegistry alertingSessionRegistry;
    private volatile boolean paused;

    @VisibleForTesting
    AlertAppender(String name, Layout<? extends Serializable> layout, Filter filter) {
        this(name, layout, filter, true, false, (AlertingSessionRegistry)AlertingSessionRegistryProvider.get());
    }

    private AlertAppender(String name, Layout<? extends Serializable> layout, Filter filter, boolean startPaused, boolean debug, AlertingSessionRegistry alertingSessionRegistry) {
        super(name, filter, layout);
        this.debug = debug;
        this.events = debug ? Collections.synchronizedList(new ArrayList()) : Collections.emptyList();
        this.paused = true;
        this.alertingSessionRegistry = alertingSessionRegistry;
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    public void append(LogEvent event) {
        LOGGER.trace("Handling append of {} in {}.", (Object)event, (Object)this);
        if (this.isPaused()) {
            LOGGER.trace("Skipping append of {} because {} is paused.", (Object)event, (Object)this);
            return;
        }
        if (!AlertLevelConverter.hasAlertLevel((Level)event.getLevel())) {
            LOGGER.trace("Skipping append of {} because level is {}.", (Object)event, (Object)event.getLevel());
            return;
        }
        if (AlertingAction.isThreadAlerting()) {
            LOGGER.trace("Skipping append of {} because {} is alerting.", (Object)event, (Object)Thread.currentThread());
            return;
        }
        this.doAppend(event);
    }

    private void doAppend(LogEvent event) {
        AlertingService alertingService = this.getAlertingService();
        if (alertingService.hasAlertListeners()) {
            this.sendAlerts(event);
        } else {
            LOGGER.trace("Skipping alert messaging for {} because listeners is empty.", (Object)event);
        }
        if (this.debug) {
            this.events.add(event);
        }
    }

    private void sendAlerts(LogEvent event) {
        AlertingService alertingService = this.getAlertingService();
        AlertLevel alertLevel = AlertLevelConverter.fromLevel((Level)event.getLevel());
        Instant instant = Instant.ofEpochMilli(event.getTimeMillis());
        String threadName = event.getThreadName();
        long threadId = Thread.currentThread().getId();
        String formattedMessage = event.getMessage().getFormattedMessage();
        String stackTrace = this.getStackTrace(event);
        alertingService.sendAlerts(alertLevel, instant, threadName, threadId, formattedMessage, stackTrace);
    }

    private String getStackTrace(LogEvent event) {
        return event.getThrown() == null ? null : ExceptionUtils.getStackTrace((Throwable)event.getThrown());
    }

    public void start() {
        LOGGER.info("Starting {}.", (Object)this);
        LOGGER.debug("Adding {} to {}.", (Object)this, (Object)this.alertingSessionRegistry);
        this.alertingSessionRegistry.addAlertingSessionListener((AlertingSessionListener)this);
        super.start();
    }

    public void stop() {
        LOGGER.info("Stopping {}.", (Object)this);
        super.stop();
        this.alertingSessionRegistry.removeAlertingSessionListener((AlertingSessionListener)this);
        LOGGER.info("{} has stopped.", (Object)this);
    }

    @Override
    public void pause() {
        LOGGER.debug("Pausing {}.", (Object)this);
        this.paused = true;
    }

    @Override
    public void resume() {
        LOGGER.debug("Resuming {}.", (Object)this);
        this.paused = false;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public void clearLogEvents() {
        this.events.clear();
    }

    @Override
    public List<LogEvent> getLogEvents() {
        return Collections.unmodifiableList(this.events);
    }

    public synchronized void createSession(AlertingService alertingService) {
        LOGGER.info("Creating session in {} with {}.", (Object)this, (Object)alertingService);
        this.setAlertingService(alertingService);
    }

    public synchronized void startSession() {
        LOGGER.info("Starting session in {}.", (Object)this);
        this.resume();
    }

    public synchronized void stopSession() {
        LOGGER.info("Stopping session in {}.", (Object)this);
        this.pause();
        this.setAlertingService((AlertingService)NullAlertingService.get());
    }

    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + ":" + this.getName() + " {alertingService=" + this.getAlertingService() + ", paused=" + this.paused + ", alertingSessionRegistry=" + this.alertingSessionRegistry + ", debug=" + this.debug + "}";
    }

    @VisibleForTesting
    void setAlertingService(AlertingService alertingService) {
        this.alertingServiceRef.set(alertingService);
    }

    @VisibleForTesting
    AlertingService getAlertingService() {
        return this.alertingServiceRef.get();
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractAppender.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<AlertAppender> {
        @PluginBuilderAttribute
        private boolean debug;
        @PluginBuilderAttribute
        private boolean startPaused = true;

        public B setStartPaused(boolean shouldStartPaused) {
            this.startPaused = shouldStartPaused;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public boolean isStartPaused() {
            return this.debug;
        }

        public B setDebug(boolean shouldDebug) {
            this.debug = shouldDebug;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public boolean isDebug() {
            return this.debug;
        }

        public AlertAppender build() {
            Layout layout = this.getOrCreateLayout();
            return new AlertAppender(this.getName(), layout, this.getFilter(), this.startPaused, this.debug, (AlertingSessionRegistry)AlertingSessionRegistryProvider.get());
        }
    }
}

