/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.test.junit.rules;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import org.junit.rules.ExternalResource;

public class DiskDirRule
extends ExternalResource {
    private File diskDir;

    protected void before() throws Throwable {
        this.diskDir = new File(".", "DiskDirRule-" + System.nanoTime());
    }

    protected void after() {
        if (!this.diskDir.exists()) {
            return;
        }
        try {
            Files.walk(this.diskDir.toPath(), new FileVisitOption[0]).forEach(path -> {
                try {
                    Files.delete(path);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Could not delete disk dir: " + this.diskDir, e);
        }
        this.diskDir.delete();
    }

    public File get() {
        this.diskDir.mkdirs();
        return this.diskDir;
    }
}

