/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.test.junit.runner;

import com.gemstone.gemfire.test.junit.runner.SuiteBlockRunner;
import java.util.ArrayList;
import java.util.List;
import org.junit.runner.Runner;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

public class SuiteRunner
extends Suite {
    public SuiteRunner(Class<?> klass, RunnerBuilder builder) throws InitializationError {
        super(klass, SuiteRunner.getRunners(klass));
    }

    private static List<Runner> getRunners(Class<?> klass) throws InitializationError {
        Suite.SuiteClasses annotation = klass.getAnnotation(Suite.SuiteClasses.class);
        if (annotation == null) {
            throw new InitializationError(String.format("class '%s' must have a SuiteClasses annotation", klass.getName()));
        }
        Class[] childClasses = annotation.value();
        ArrayList<Runner> runners = new ArrayList<Runner>();
        for (Class childClass : childClasses) {
            runners.add((Runner)new SuiteBlockRunner(klass, childClass));
        }
        return runners;
    }
}

