/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.test.junit.rules;

import com.gemstone.gemfire.test.junit.Repeat;
import java.io.Serializable;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class RepeatRule
implements TestRule,
Serializable {
    protected static final int DEFAULT_REPETITIONS = 1;

    public Statement apply(final Statement statement, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                RepeatRule.this.evaluate(statement, description);
            }
        };
    }

    protected void evaluate(Statement statement, Description description) throws Throwable {
        if (this.isTest(description)) {
            Repeat repeat = (Repeat)description.getAnnotation(Repeat.class);
            int repetitions = this.getRepetitions(repeat);
            for (int count = 0; count < repetitions; ++count) {
                statement.evaluate();
            }
        }
    }

    private int getRepetitions(Repeat repeat) {
        int repetitions = 1;
        if (repeat != null) {
            repetitions = !"".equals(repeat.property()) ? Integer.getInteger(repeat.property(), 1).intValue() : repeat.value();
        }
        if (repetitions < 1) {
            throw new IllegalArgumentException("Repeat value must be a positive integer");
        }
        return repetitions;
    }

    private boolean isTest(Description description) {
        return description.isSuite() || description.isTest();
    }
}

