/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.test.junit.rules.serializable;

import com.gemstone.gemfire.test.junit.rules.serializable.FieldSerializationUtils;
import com.gemstone.gemfire.test.junit.rules.serializable.SerializableTestRule;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.junit.rules.Timeout;

public class SerializableTimeout
extends Timeout
implements SerializableTestRule {
    public static Builder builder() {
        return new Builder();
    }

    public SerializableTimeout(long timeout, TimeUnit timeUnit) {
        super(timeout, timeUnit);
    }

    protected SerializableTimeout(Builder builder) {
        super((Timeout.Builder)builder);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("SerializationProxy required");
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private static class SerializationProxy
    implements Serializable {
        private final long timeout;
        private final TimeUnit timeUnit;
        private final boolean lookForStuckThread;

        SerializationProxy(SerializableTimeout instance) {
            this.timeout = (Long)FieldSerializationUtils.readField(Timeout.class, instance, "timeout");
            this.timeUnit = (TimeUnit)((Object)FieldSerializationUtils.readField(Timeout.class, instance, "timeUnit"));
            this.lookForStuckThread = (Boolean)FieldSerializationUtils.readField(Timeout.class, instance, "lookForStuckThread");
        }

        private Object readResolve() {
            return new Builder().withTimeout(this.timeout, this.timeUnit).withLookingForStuckThread(this.lookForStuckThread).build();
        }
    }

    public static class Builder
    extends Timeout.Builder {
        protected Builder() {
        }

        public Builder withTimeout(long timeout, TimeUnit unit) {
            super.withTimeout(timeout, unit);
            return this;
        }

        public Builder withLookingForStuckThread(boolean enable) {
            super.withLookingForStuckThread(enable);
            return this;
        }

        public SerializableTimeout build() {
            return new SerializableTimeout(this);
        }
    }
}

