/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.test.junit.rules;

import java.util.concurrent.TimeUnit;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.rules.ExpectedException;
import org.junit.rules.TestRule;
import org.junit.runners.model.Statement;

public class ExpectedTimeoutRule
implements TestRule {
    private ExpectedException delegate = ExpectedException.none();
    private boolean expectsThrowable;
    private long minDuration;
    private long maxDuration;
    private TimeUnit timeUnit;

    public static ExpectedTimeoutRule none() {
        return new ExpectedTimeoutRule();
    }

    private ExpectedTimeoutRule() {
    }

    public ExpectedTimeoutRule expectMinimumDuration(long minDuration) {
        this.minDuration = minDuration;
        return this;
    }

    public ExpectedTimeoutRule expectMaximumDuration(long maxDuration) {
        this.maxDuration = maxDuration;
        return this;
    }

    public ExpectedTimeoutRule expectTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
        return this;
    }

    public void expect(Matcher<?> matcher) {
        this.delegate.expect(matcher);
    }

    public void expect(Class<? extends Throwable> type) {
        this.delegate.expect(type);
        this.expectsThrowable = true;
    }

    public void expectMessage(String substring) {
        this.delegate.expectMessage(substring);
    }

    public void expectMessage(Matcher<String> matcher) {
        this.delegate.expectMessage(matcher);
    }

    public void expectCause(Matcher<? extends Throwable> expectedCause) {
        this.delegate.expectCause(expectedCause);
    }

    protected boolean expectsTimeout() {
        return this.minDuration > 0L || this.maxDuration > 0L;
    }

    protected boolean expectsThrowable() {
        return this.expectsThrowable;
    }

    public Statement apply(Statement base, org.junit.runner.Description description) {
        Statement next = this.delegate.apply(base, description);
        return new ExpectedTimeoutStatement(next);
    }

    private void handleTime(Long duration) {
        if (this.expectsTimeout()) {
            Assert.assertThat((Object)this.timeUnit.convert(duration, TimeUnit.NANOSECONDS), (Matcher)new TimeMatcher(this.timeUnit, this.minDuration, this.maxDuration));
        }
    }

    private class ExpectedTimeoutStatement
    extends Statement {
        private final Statement next;

        public ExpectedTimeoutStatement(Statement base) {
            this.next = base;
        }

        public void evaluate() throws Throwable {
            long start = System.nanoTime();
            this.next.evaluate();
            ExpectedTimeoutRule.this.handleTime(System.nanoTime() - start);
        }
    }

    private static class TimeMatcher
    extends TypeSafeMatcher<Long> {
        private final TimeUnit timeUnit;
        private final long minDuration;
        private final long maxDuration;

        public TimeMatcher(TimeUnit timeUnit, long minDuration, long maxDuration) {
            this.timeUnit = timeUnit;
            this.minDuration = minDuration;
            this.maxDuration = maxDuration;
        }

        public boolean matchesSafely(Long duration) {
            return duration >= this.minDuration && duration <= this.maxDuration;
        }

        public void describeTo(Description description) {
            description.appendText("expects duration to be greater than or equal to ").appendValue((Object)this.minDuration).appendText(" and less than or equal to ").appendValue((Object)this.maxDuration).appendText(" ").appendValue((Object)this.timeUnit);
        }
    }
}

