/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.test.junit.rules;

import com.gemstone.gemfire.test.junit.ConditionalIgnore;
import com.gemstone.gemfire.test.junit.IgnoreCondition;
import com.gemstone.gemfire.test.junit.support.IgnoreConditionEvaluationException;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.junit.AssumptionViolatedException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class ConditionalIgnoreRule
implements TestRule,
Serializable {
    protected static final String DATE_FORMAT_PATTERN = "yyyy-MM-dd";
    protected static final String DEFAULT_MESSAGE = "Ignoring test case (%1$s) of test class (%2$s)!";
    protected static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                ConditionalIgnoreRule.this.evaluate(base, description);
            }
        };
    }

    public final void evaluate(Statement statement, Description description) throws Throwable {
        this.throwOnIgnoreTest(statement, description).evaluate();
    }

    protected Statement throwOnIgnoreTest(Statement statement, Description description) {
        if (this.isTest(description)) {
            boolean ignoreTest = false;
            String message = "";
            ConditionalIgnore testCaseAnnotation = (ConditionalIgnore)description.getAnnotation(ConditionalIgnore.class);
            if (testCaseAnnotation != null) {
                ignoreTest = this.evaluate(testCaseAnnotation, description);
                message = testCaseAnnotation.value();
            } else if (description.getTestClass().isAnnotationPresent(ConditionalIgnore.class)) {
                ConditionalIgnore testClassAnnotation = description.getTestClass().getAnnotation(ConditionalIgnore.class);
                ignoreTest = this.evaluate(testClassAnnotation, description);
                message = testClassAnnotation.value();
            }
            if (ignoreTest) {
                throw new AssumptionViolatedException(this.format(message, description));
            }
        }
        return statement;
    }

    protected boolean isTest(Description description) {
        return description.isSuite() || description.isTest();
    }

    protected String format(String message, Description description) {
        message = !message.isEmpty() ? message : DEFAULT_MESSAGE;
        return String.format(message, description.getMethodName(), description.getClassName());
    }

    protected boolean evaluate(ConditionalIgnore conditionalIgnoreAnnotation, Description description) {
        return this.evaluateCondition(conditionalIgnoreAnnotation.condition(), description) || this.evaluateUntil(conditionalIgnoreAnnotation.until());
    }

    protected boolean evaluateCondition(Class<? extends IgnoreCondition> ignoreConditionType, Description description) {
        try {
            return ignoreConditionType.newInstance().evaluate(description);
        }
        catch (Exception e) {
            throw new IgnoreConditionEvaluationException(String.format("failed to evaluate IgnoreCondition: %1$s", ignoreConditionType.getName()), e);
        }
    }

    protected boolean evaluateUntil(String timestamp) {
        try {
            return DATE_FORMAT.parse(timestamp).after(Calendar.getInstance().getTime());
        }
        catch (ParseException e) {
            return false;
        }
    }
}

