/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.http.service;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.internal.HttpService;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.cache.CacheService;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.net.SSLConfig;
import org.apache.geode.internal.net.SSLConfigurationFactory;
import org.apache.geode.internal.net.SSLUtil;
import org.apache.geode.internal.security.SecurableCommunicationChannel;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.internal.beans.CacheServiceMBeanBase;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.eclipse.jetty.ee10.annotations.AnnotationConfiguration;
import org.eclipse.jetty.ee10.servlet.ListenerHolder;
import org.eclipse.jetty.ee10.servlet.Source;
import org.eclipse.jetty.ee10.webapp.Configuration;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.AliasCheck;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.SymlinkAllowedResourceAliasChecker;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class InternalHttpService
implements HttpService {
    private static final Logger logger = LogService.getLogger();
    private static final Marker LIFECYCLE = MarkerManager.getMarker((String)"HTTP_LIFECYCLE");
    private static final Marker WEBAPP = MarkerManager.getMarker((String)"HTTP_WEBAPP");
    private static final Marker SERVLET_CONTEXT = MarkerManager.getMarker((String)"SERVLET_CONTEXT");
    private static final Marker CONFIG = MarkerManager.getMarker((String)"HTTP_CONFIG");
    private static final Marker SECURITY = MarkerManager.getMarker((String)"HTTP_SECURITY");
    private Server httpServer;
    private String bindAddress = "0.0.0.0";
    private int port;
    private static final String FILE_PATH_SEPARATOR = System.getProperty("file.separator");
    private static final String USER_DIR = System.getProperty("user.dir");
    private static final String USER_NAME = System.getProperty("user.name");
    private static final String HTTPS = "https";
    private final List<WebAppContext> webApps = new ArrayList<WebAppContext>();

    public boolean init(Cache cache) {
        InternalDistributedSystem distributedSystem = (InternalDistributedSystem)cache.getDistributedSystem();
        DistributionConfig systemConfig = distributedSystem.getConfig();
        if (((InternalCache)cache).isClient()) {
            if (logger.isDebugEnabled()) {
                logger.debug(LIFECYCLE, "HTTP service not initialized: client cache");
            }
            return false;
        }
        if (systemConfig.getHttpServicePort() == 0) {
            logger.info(CONFIG, "HTTP service disabled: http-service-port=0");
            return false;
        }
        try {
            this.createJettyServer(systemConfig.getHttpServiceBindAddress(), systemConfig.getHttpServicePort(), SSLConfigurationFactory.getSSLConfigForComponent((DistributionConfig)systemConfig, (SecurableCommunicationChannel)SecurableCommunicationChannel.WEB));
        }
        catch (Throwable ex) {
            logger.warn(LIFECYCLE, "Failed to enable HTTP service: {}", (Object)ex.getMessage());
            return false;
        }
        return true;
    }

    @VisibleForTesting
    public void createJettyServer(String bindAddress, int port, SSLConfig sslConfig) {
        ServerConnector connector;
        this.httpServer = new Server();
        this.httpServer.setHandler((Handler)new Handler.Sequence(new Handler[0]));
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSecureScheme(HTTPS);
        httpConfig.setSecurePort(port);
        if (sslConfig.isEnabled()) {
            SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
            if (StringUtils.isNotBlank((CharSequence)sslConfig.getAlias())) {
                sslContextFactory.setCertAlias(sslConfig.getAlias());
            }
            sslContextFactory.setNeedClientAuth(sslConfig.isRequireAuth());
            sslContextFactory.setSniRequired(false);
            if (!sslConfig.isAnyCiphers()) {
                sslContextFactory.setExcludeCipherSuites(new String[0]);
                sslContextFactory.setIncludeCipherSuites(sslConfig.getCiphersAsStringArray());
            }
            sslContextFactory.setSslContext(SSLUtil.createAndConfigureSSLContext((SSLConfig)sslConfig, (boolean)false));
            if (logger.isDebugEnabled()) {
                logger.debug(SECURITY, "SSL context factory configuration: {}", (Object)sslContextFactory.dump());
            }
            SecureRequestCustomizer customizer = new SecureRequestCustomizer();
            customizer.setSniHostCheck(false);
            httpConfig.addCustomizer((HttpConfiguration.Customizer)customizer);
            SslConnectionFactory sslConnectionFactory = new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString());
            connector = new ServerConnector(this.httpServer, new ConnectionFactory[]{sslConnectionFactory, new HttpConnectionFactory(httpConfig)});
            connector.setPort(port);
        } else {
            connector = new ServerConnector(this.httpServer, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
            connector.setPort(port);
        }
        this.httpServer.setConnectors(new Connector[]{connector});
        if (StringUtils.isNotBlank((CharSequence)bindAddress)) {
            connector.setHost(bindAddress);
        }
        if (bindAddress != null && !bindAddress.isEmpty()) {
            this.bindAddress = bindAddress;
        }
        this.port = port;
        logger.info(LIFECYCLE, "HTTP service initialized: {}", (Object)new LogContext().add("port", port).add("bindAddress", bindAddress != null && !bindAddress.isEmpty() ? bindAddress : "0.0.0.0").add("ssl", sslConfig.isEnabled()));
    }

    public Class<? extends CacheService> getInterface() {
        return HttpService.class;
    }

    public CacheServiceMBeanBase getMBean() {
        return null;
    }

    public Server getHttpServer() {
        return this.httpServer;
    }

    public synchronized void addWebApplication(String webAppContext, Path warFilePath, Map<String, Object> attributeNameValuePairs) throws Exception {
        if (this.httpServer == null) {
            logger.warn(WEBAPP, "Cannot add webapp, HTTP service not started: webapp={}", (Object)webAppContext);
            return;
        }
        logger.info(WEBAPP, "Adding webapp {}", (Object)webAppContext);
        WebAppContext webapp = new WebAppContext();
        webapp.setContextPath(webAppContext);
        webapp.setWar(warFilePath.toString());
        webapp.addConfiguration(new Configuration[]{new AnnotationConfiguration()});
        webapp.setParentLoaderPriority(false);
        webapp.setAttribute("org.eclipse.jetty.ee10.webapp.ContainerIncludeJarPattern", (Object)".*/jakarta\\.servlet-api-[^/]*\\.jar$|.*/jakarta\\.servlet\\.jsp\\.jstl-.*\\.jar$|.*/com\\.fasterxml\\.jackson\\.annotation\\..*\\.jar$");
        webapp.setAttribute("org.eclipse.jetty.ee10.webapp.WebInfIncludeJarPattern", (Object)".*/com\\.fasterxml\\.jackson\\.(?!annotation).*\\.jar$");
        webapp.setExtraClasspath(new File(".").getAbsolutePath());
        webapp.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        webapp.addAliasCheck((AliasCheck)new SymlinkAllowedResourceAliasChecker((ContextHandler)webapp));
        if (attributeNameValuePairs != null) {
            attributeNameValuePairs.forEach((arg_0, arg_1) -> ((WebAppContext)webapp).setAttribute(arg_0, arg_1));
            ListenerHolder listenerHolder = new ListenerHolder(Source.EMBEDDED);
            listenerHolder.setListener((EventListener)((Object)new ServletContextAttributeListener(attributeNameValuePairs, webAppContext)));
            webapp.getServletHandler().addListener(listenerHolder);
        }
        File tmpPath = new File(this.getWebAppBaseDirectory(webAppContext));
        tmpPath.mkdirs();
        webapp.setTempDirectory(tmpPath);
        if (logger.isDebugEnabled()) {
            ClassLoader webappClassLoader = webapp.getClassLoader();
            ClassLoader parentClassLoader = webappClassLoader != null ? webappClassLoader.getParent() : null;
            logger.debug(CONFIG, "Webapp configuration: {}", (Object)new LogContext().add("context", webAppContext).add("tempDir", tmpPath.getAbsolutePath()).add("parentLoaderPriority", webapp.isParentLoaderPriority()).add("webappClassLoader", webappClassLoader).add("parentClassLoader", parentClassLoader).add("annotationConfigEnabled", true).add("servletContextListenerAdded", attributeNameValuePairs != null));
        }
        ((Handler.Sequence)this.httpServer.getHandler()).addHandler((Handler)webapp);
        this.webApps.add(webapp);
        logger.info(WEBAPP, "Webapp deployed successfully: {}", (Object)new LogContext().add("context", webAppContext).add("totalWebapps", this.webApps.size()).add("servletContextListener", attributeNameValuePairs != null));
    }

    private String getWebAppBaseDirectory(String context) {
        String underscoredContext = context.replace("/", "_");
        String uuid = UUID.randomUUID().toString().substring(0, 8);
        return USER_DIR.concat(FILE_PATH_SEPARATOR).concat("GemFire_" + USER_NAME).concat(FILE_PATH_SEPARATOR).concat("services").concat(FILE_PATH_SEPARATOR).concat("http").concat(FILE_PATH_SEPARATOR).concat(StringUtils.isBlank((CharSequence)this.bindAddress) ? "0.0.0.0" : this.bindAddress).concat("_").concat(String.valueOf(this.port).concat(underscoredContext)).concat("_").concat(uuid);
    }

    public synchronized void restartHttpServer() throws Exception {
        if (this.httpServer == null) {
            logger.warn(LIFECYCLE, "Cannot restart HTTP server: server not initialized");
            return;
        }
        boolean isStarted = this.httpServer.isStarted();
        int webappCount = this.webApps.size();
        logger.info(LIFECYCLE, "{} HTTP server: {}", (Object)(isStarted ? "Restarting" : "Starting"), (Object)new LogContext().add("webappCount", webappCount).add("firstStart", !isStarted));
        if (logger.isDebugEnabled()) {
            logger.debug(LIFECYCLE, "Jetty lifecycle will: {} -> {} -> {} -> {}", (Object)"loadConfigurations", (Object)"preConfigure", (Object)"configure (ServletContainerInitializer discovery)", (Object)"start");
        }
        if (isStarted) {
            if (logger.isDebugEnabled()) {
                logger.debug(LIFECYCLE, "Stopping running server before restart");
            }
            this.httpServer.stop();
            Handler.Sequence handlerSequence = (Handler.Sequence)this.httpServer.getHandler();
            if (handlerSequence != null) {
                for (Handler handler : handlerSequence.getHandlers()) {
                    handlerSequence.removeHandler(handler);
                }
                for (WebAppContext webapp : this.webApps) {
                    handlerSequence.addHandler((Handler)webapp);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug(WEBAPP, "Re-added webapp to handler sequence: context={}", (Object)webapp.getContextPath());
                }
            }
        }
        this.httpServer.start();
        for (WebAppContext webapp : this.webApps) {
            boolean available = webapp.isAvailable();
            Throwable unavailableException = webapp.getUnavailableException();
            if (!available || unavailableException != null) {
                logger.error(LIFECYCLE, "Webapp failed to start: context={}, available={}, exception={}", (Object)webapp.getContextPath(), (Object)available, (Object)(unavailableException != null ? unavailableException.getMessage() : "none"), (Object)unavailableException);
                continue;
            }
            logger.info(WEBAPP, "Webapp started successfully: context={}", (Object)webapp.getContextPath());
        }
        logger.info(LIFECYCLE, "HTTP server {} successfully: {}", (Object)(isStarted ? "restarted" : "started"), (Object)new LogContext().add("webappCount", webappCount).add("port", this.port).add("bindAddress", this.bindAddress));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        if (this.httpServer == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(LIFECYCLE, "Stopping HTTP service: webappCount={}", (Object)this.webApps.size());
        }
        try {
            for (WebAppContext webapp : this.webApps) {
                webapp.stop();
            }
            this.httpServer.stop();
            return;
        }
        catch (Exception e) {
            logger.warn(LIFECYCLE, "Failed to stop HTTP service: {}", (Object)e.getMessage(), (Object)e);
            return;
        }
        finally {
            try {
                this.httpServer.destroy();
            }
            catch (Exception e) {
                logger.warn(LIFECYCLE, "Failed to release HTTP service resources: {}", (Object)e.getMessage(), (Object)e);
            }
            finally {
                this.httpServer = null;
            }
        }
    }

    private static class LogContext {
        private final LinkedHashMap<String, Object> context = new LinkedHashMap();

        private LogContext() {
        }

        public LogContext add(String key, Object value) {
            this.context.put(key, value);
            return this;
        }

        public String toString() {
            return this.context.entrySet().stream().map(e -> (String)e.getKey() + "=" + String.valueOf(e.getValue())).collect(Collectors.joining(", "));
        }
    }

    private static class ServletContextAttributeListener
    implements ServletContextListener {
        private static final Logger logger = LogService.getLogger();
        private final Map<String, Object> attributes;
        private final String webAppContext;

        public ServletContextAttributeListener(Map<String, Object> attributes, String webAppContext) {
            this.attributes = attributes;
            this.webAppContext = webAppContext;
        }

        public void contextInitialized(ServletContextEvent sce) {
            ServletContext ctx = sce.getServletContext();
            logger.info(SERVLET_CONTEXT, "Initializing ServletContext: {}", (Object)new LogContext().add("webapp", this.webAppContext).add("attributeCount", this.attributes.size()));
            this.attributes.forEach((key, value) -> {
                ctx.setAttribute(key, value);
                if (logger.isDebugEnabled()) {
                    logger.debug(SERVLET_CONTEXT, "Set ServletContext attribute: key={}, value={}", key, value);
                }
            });
            logger.info(SERVLET_CONTEXT, "ServletContext initialized: {}", (Object)new LogContext().add("webapp", this.webAppContext).add("attributesTransferred", this.attributes.size()));
        }

        public void contextDestroyed(ServletContextEvent sce) {
            if (logger.isDebugEnabled()) {
                logger.debug(SERVLET_CONTEXT, "ServletContext destroyed: webapp={}", (Object)this.webAppContext);
            }
        }
    }
}

