/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import org.apache.geode.cache.Cache;
import org.apache.geode.cache.configuration.RegionConfig;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.query.IndexExistsException;
import org.apache.geode.cache.query.IndexInvalidException;
import org.apache.geode.cache.query.IndexNameConflictException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.RegionNotFoundException;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.i18n.CliStrings;

public class CreateIndexFunction
implements InternalFunction<RegionConfig.Index> {
    private static final long serialVersionUID = 1L;
    private static final String ID = "org.apache.geode.management.internal.cli.functions.CreateIndexFunction";

    public String getId() {
        return ID;
    }

    public void execute(FunctionContext<RegionConfig.Index> context) {
        RegionConfig.Index indexInfo = (RegionConfig.Index)context.getArguments();
        String memberId = null;
        try {
            Cache cache = context.getCache();
            memberId = cache.getDistributedSystem().getDistributedMember().getId();
            QueryService queryService = cache.getQueryService();
            String indexName = indexInfo.getName();
            String indexedExpression = indexInfo.getExpression();
            String fromClause = indexInfo.getFromClause();
            if (indexInfo.isKeyIndex().booleanValue()) {
                queryService.createKeyIndex(indexName, indexedExpression, fromClause);
            } else if ("hash".equals(indexInfo.getType())) {
                queryService.createHashIndex(indexName, indexedExpression, fromClause);
            } else {
                queryService.createIndex(indexName, indexedExpression, fromClause);
            }
            context.getResultSender().lastResult((Object)new CliFunctionResult(memberId, true, "Index successfully created"));
        }
        catch (IndexExistsException e) {
            String message = CliStrings.format((String)"Index \"{0}\" already exists.  Create failed due to duplicate definition.", (Object)indexInfo.getName());
            context.getResultSender().lastResult((Object)new CliFunctionResult(memberId, CliFunctionResult.StatusState.IGNORABLE, message));
        }
        catch (IndexNameConflictException e) {
            String message = CliStrings.format((String)"Index \"{0}\" already exists.  Create failed due to duplicate name.", (Object)indexInfo.getName());
            context.getResultSender().lastResult((Object)new CliFunctionResult(memberId, CliFunctionResult.StatusState.IGNORABLE, message));
        }
        catch (RegionNotFoundException e) {
            String message = CliStrings.format((String)"Region not found : \"{0}\"", (Object)indexInfo.getFromClause());
            context.getResultSender().lastResult((Object)new CliFunctionResult(memberId, false, message));
        }
        catch (IndexInvalidException e) {
            context.getResultSender().lastResult((Object)new CliFunctionResult(memberId, (Object)e, e.getMessage()));
        }
        catch (Exception e) {
            String exceptionMessage = CliStrings.format((String)"Exception : {0} , Message : {1}", (Object[])new Object[]{e.getClass().getName(), e.getMessage()});
            context.getResultSender().lastResult((Object)new CliFunctionResult(memberId, (Object)e, exceptionMessage));
        }
    }
}

