/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.converters;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class DiskStoreNameConverter
implements Converter<String, String> {
    public String convert(@NonNull String source) {
        return source;
    }

    public Set<String> getCompletionValues() {
        Map diskStoreInfo;
        TreeSet<String> diskStoreNames = new TreeSet<String>();
        Gfsh gfsh = Gfsh.getCurrentInstance();
        if (gfsh != null && gfsh.isConnectedAndReady() && (diskStoreInfo = gfsh.getOperationInvoker().getDistributedSystemMXBean().listMemberDiskstore()) != null) {
            Set entries = diskStoreInfo.entrySet();
            for (Map.Entry entry : entries) {
                String[] value = (String[])entry.getValue();
                if (value == null) continue;
                diskStoreNames.addAll(Arrays.asList(value));
            }
        }
        return diskStoreNames;
    }
}

