/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.completion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.geode.management.internal.cli.Completion;
import org.apache.geode.management.internal.cli.CompletionContext;
import org.apache.geode.management.internal.cli.completion.ValueCompletionProvider;

public class LogLevelCompletionProvider
implements ValueCompletionProvider {
    private static final List<String> LOG_LEVELS = Arrays.asList("ALL", "TRACE", "DEBUG", "INFO", "WARN", "ERROR", "FATAL", "OFF");

    @Override
    public boolean supports(Class<?> targetType) {
        return String.class.equals(targetType);
    }

    @Override
    public List<Completion> getCompletions(Class<?> targetType, String partialValue, CompletionContext context) {
        ArrayList<Completion> completions = new ArrayList<Completion>();
        String optionName = context.getOptionName();
        if (optionName == null || !optionName.toLowerCase().contains("loglevel")) {
            return completions;
        }
        String partial = partialValue == null ? "" : partialValue.toUpperCase();
        for (String level : LOG_LEVELS) {
            if (!level.startsWith(partial)) continue;
            completions.add(new Completion(level));
        }
        return completions;
    }
}

