/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.completion;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.geode.management.internal.cli.CommandManager;
import org.apache.geode.management.internal.cli.Completion;
import org.apache.geode.management.internal.cli.CompletionContext;
import org.apache.geode.management.internal.cli.completion.ValueCompletionProvider;
import org.apache.geode.management.internal.cli.help.Helper;

public class HintTopicCompletionProvider
implements ValueCompletionProvider {
    @Override
    public boolean supports(Class<?> targetType) {
        return String.class.equals(targetType);
    }

    @Override
    public List<Completion> getCompletions(Class<?> targetType, String partialValue, CompletionContext context) {
        ArrayList<Completion> completions = new ArrayList<Completion>();
        String optionName = context.getOptionName();
        String commandName = context.getCommandName();
        if (optionName == null || !optionName.equals("topic")) {
            return completions;
        }
        if (commandName == null || !commandName.equals("hint")) {
            return completions;
        }
        Object cmdMgr = context.getCommandManager();
        if (cmdMgr == null || !(cmdMgr instanceof CommandManager)) {
            return completions;
        }
        CommandManager commandManager = (CommandManager)cmdMgr;
        Helper helper = commandManager.getHelper();
        if (helper == null) {
            return completions;
        }
        Set<String> topicNames = helper.getTopicNames();
        String partial = partialValue == null ? "" : partialValue;
        for (String topicName : topicNames) {
            if (partial.isEmpty()) {
                completions.add(new Completion(topicName));
                continue;
            }
            if (topicName.startsWith(partial)) {
                completions.add(new Completion(topicName));
                continue;
            }
            if (!topicName.toLowerCase().startsWith(partial.toLowerCase())) continue;
            String completionStr = partial + topicName.substring(partial.length());
            completions.add(new Completion(completionStr));
        }
        return completions;
    }
}

